import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermHdinsightClusterConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/hdinsight_cluster#name DataAzurermHdinsightCluster#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/hdinsight_cluster#resource_group_name DataAzurermHdinsightCluster#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/hdinsight_cluster#timeouts DataAzurermHdinsightCluster#timeouts}
    */
    readonly timeouts?: DataAzurermHdinsightClusterTimeouts;
}
export declare class DataAzurermHdinsightClusterGateway extends cdktf.ComplexComputedList {
    get enabled(): cdktf.IResolvable;
    get password(): string;
    get username(): string;
}
export interface DataAzurermHdinsightClusterTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/hdinsight_cluster#read DataAzurermHdinsightCluster#read}
    */
    readonly read?: string;
}
export declare function dataAzurermHdinsightClusterTimeoutsToTerraform(struct?: DataAzurermHdinsightClusterTimeoutsOutputReference | DataAzurermHdinsightClusterTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermHdinsightClusterTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataAzurermHdinsightClusterTimeouts | undefined;
    set internalValue(value: DataAzurermHdinsightClusterTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/hdinsight_cluster azurerm_hdinsight_cluster}
*/
export declare class DataAzurermHdinsightCluster extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/hdinsight_cluster azurerm_hdinsight_cluster} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermHdinsightClusterConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermHdinsightClusterConfig);
    get clusterVersion(): string;
    componentVersions(key: string): string | cdktf.IResolvable;
    get edgeSshEndpoint(): string;
    gateway(index: string): DataAzurermHdinsightClusterGateway;
    get httpsEndpoint(): string;
    get id(): string;
    get kafkaRestProxyEndpoint(): string;
    get kind(): string;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get sshEndpoint(): string;
    tags(key: string): string | cdktf.IResolvable;
    get tier(): string;
    get tlsMinVersion(): string;
    private _timeouts;
    get timeouts(): DataAzurermHdinsightClusterTimeoutsOutputReference;
    putTimeouts(value: DataAzurermHdinsightClusterTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermHdinsightClusterTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
