import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermImageConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/image#name DataAzurermImage#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/image#name_regex DataAzurermImage#name_regex}
    */
    readonly nameRegex?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/image#resource_group_name DataAzurermImage#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/image#sort_descending DataAzurermImage#sort_descending}
    */
    readonly sortDescending?: boolean | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/image#timeouts DataAzurermImage#timeouts}
    */
    readonly timeouts?: DataAzurermImageTimeouts;
}
export declare class DataAzurermImageDataDisk extends cdktf.ComplexComputedList {
    get blobUri(): string;
    get caching(): string;
    get lun(): number;
    get managedDiskId(): string;
    get sizeGb(): number;
}
export declare class DataAzurermImageOsDisk extends cdktf.ComplexComputedList {
    get blobUri(): string;
    get caching(): string;
    get managedDiskId(): string;
    get osState(): string;
    get osType(): string;
    get sizeGb(): number;
}
export interface DataAzurermImageTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/image#read DataAzurermImage#read}
    */
    readonly read?: string;
}
export declare function dataAzurermImageTimeoutsToTerraform(struct?: DataAzurermImageTimeoutsOutputReference | DataAzurermImageTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermImageTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataAzurermImageTimeouts | undefined;
    set internalValue(value: DataAzurermImageTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/image azurerm_image}
*/
export declare class DataAzurermImage extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/image azurerm_image} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermImageConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermImageConfig);
    dataDisk(index: string): DataAzurermImageDataDisk;
    get id(): string;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _nameRegex?;
    get nameRegex(): string;
    set nameRegex(value: string);
    resetNameRegex(): void;
    get nameRegexInput(): string | undefined;
    osDisk(index: string): DataAzurermImageOsDisk;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _sortDescending?;
    get sortDescending(): boolean | cdktf.IResolvable;
    set sortDescending(value: boolean | cdktf.IResolvable);
    resetSortDescending(): void;
    get sortDescendingInput(): boolean | cdktf.IResolvable | undefined;
    tags(key: string): string | cdktf.IResolvable;
    get zoneResilient(): cdktf.IResolvable;
    private _timeouts;
    get timeouts(): DataAzurermImageTimeoutsOutputReference;
    putTimeouts(value: DataAzurermImageTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermImageTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
