import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermKeyVaultCertificateConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/key_vault_certificate#key_vault_id DataAzurermKeyVaultCertificate#key_vault_id}
    */
    readonly keyVaultId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/key_vault_certificate#name DataAzurermKeyVaultCertificate#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/key_vault_certificate#version DataAzurermKeyVaultCertificate#version}
    */
    readonly version?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/key_vault_certificate#timeouts DataAzurermKeyVaultCertificate#timeouts}
    */
    readonly timeouts?: DataAzurermKeyVaultCertificateTimeouts;
}
export declare class DataAzurermKeyVaultCertificateCertificatePolicyIssuerParameters extends cdktf.ComplexComputedList {
    get name(): string;
}
export declare class DataAzurermKeyVaultCertificateCertificatePolicyKeyProperties extends cdktf.ComplexComputedList {
    get curve(): string;
    get exportable(): cdktf.IResolvable;
    get keySize(): number;
    get keyType(): string;
    get reuseKey(): cdktf.IResolvable;
}
export declare class DataAzurermKeyVaultCertificateCertificatePolicyLifetimeActionAction extends cdktf.ComplexComputedList {
    get actionType(): string;
}
export declare class DataAzurermKeyVaultCertificateCertificatePolicyLifetimeActionTrigger extends cdktf.ComplexComputedList {
    get daysBeforeExpiry(): number;
    get lifetimePercentage(): number;
}
export declare class DataAzurermKeyVaultCertificateCertificatePolicyLifetimeAction extends cdktf.ComplexComputedList {
    get action(): cdktf.IResolvable;
    get trigger(): cdktf.IResolvable;
}
export declare class DataAzurermKeyVaultCertificateCertificatePolicySecretProperties extends cdktf.ComplexComputedList {
    get contentType(): string;
}
export declare class DataAzurermKeyVaultCertificateCertificatePolicyX509CertificatePropertiesSubjectAlternativeNames extends cdktf.ComplexComputedList {
    get dnsNames(): string[];
    get emails(): string[];
    get upns(): string[];
}
export declare class DataAzurermKeyVaultCertificateCertificatePolicyX509CertificateProperties extends cdktf.ComplexComputedList {
    get extendedKeyUsage(): string[];
    get keyUsage(): string[];
    get subject(): string;
    get subjectAlternativeNames(): cdktf.IResolvable;
    get validityInMonths(): number;
}
export declare class DataAzurermKeyVaultCertificateCertificatePolicy extends cdktf.ComplexComputedList {
    get issuerParameters(): cdktf.IResolvable;
    get keyProperties(): cdktf.IResolvable;
    get lifetimeAction(): cdktf.IResolvable;
    get secretProperties(): cdktf.IResolvable;
    get x509CertificateProperties(): cdktf.IResolvable;
}
export interface DataAzurermKeyVaultCertificateTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/key_vault_certificate#read DataAzurermKeyVaultCertificate#read}
    */
    readonly read?: string;
}
export declare function dataAzurermKeyVaultCertificateTimeoutsToTerraform(struct?: DataAzurermKeyVaultCertificateTimeoutsOutputReference | DataAzurermKeyVaultCertificateTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermKeyVaultCertificateTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataAzurermKeyVaultCertificateTimeouts | undefined;
    set internalValue(value: DataAzurermKeyVaultCertificateTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/key_vault_certificate azurerm_key_vault_certificate}
*/
export declare class DataAzurermKeyVaultCertificate extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/key_vault_certificate azurerm_key_vault_certificate} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermKeyVaultCertificateConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermKeyVaultCertificateConfig);
    get certificateData(): string;
    get certificateDataBase64(): string;
    certificatePolicy(index: string): DataAzurermKeyVaultCertificateCertificatePolicy;
    get expires(): string;
    get id(): string;
    private _keyVaultId?;
    get keyVaultId(): string;
    set keyVaultId(value: string);
    get keyVaultIdInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get notBefore(): string;
    get secretId(): string;
    tags(key: string): string | cdktf.IResolvable;
    get thumbprint(): string;
    private _version?;
    get version(): string;
    set version(value: string);
    resetVersion(): void;
    get versionInput(): string | undefined;
    get versionlessId(): string;
    get versionlessSecretId(): string;
    private _timeouts;
    get timeouts(): DataAzurermKeyVaultCertificateTimeoutsOutputReference;
    putTimeouts(value: DataAzurermKeyVaultCertificateTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermKeyVaultCertificateTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
