import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermKubernetesClusterConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/kubernetes_cluster#name DataAzurermKubernetesCluster#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/kubernetes_cluster#resource_group_name DataAzurermKubernetesCluster#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/kubernetes_cluster#timeouts DataAzurermKubernetesCluster#timeouts}
    */
    readonly timeouts?: DataAzurermKubernetesClusterTimeouts;
}
export declare class DataAzurermKubernetesClusterAciConnectorLinux extends cdktf.ComplexComputedList {
    get subnetName(): string;
}
export declare class DataAzurermKubernetesClusterAddonProfileAzureKeyvaultSecretsProviderSecretIdentity extends cdktf.ComplexComputedList {
    get clientId(): string;
    get objectId(): string;
    get userAssignedIdentityId(): string;
}
export declare class DataAzurermKubernetesClusterAddonProfileAzureKeyvaultSecretsProvider extends cdktf.ComplexComputedList {
    get enabled(): cdktf.IResolvable;
    get secretIdentity(): cdktf.IResolvable;
    get secretRotationEnabled(): string;
    get secretRotationInterval(): string;
}
export declare class DataAzurermKubernetesClusterAddonProfileAzurePolicy extends cdktf.ComplexComputedList {
    get enabled(): cdktf.IResolvable;
}
export declare class DataAzurermKubernetesClusterAddonProfileHttpApplicationRouting extends cdktf.ComplexComputedList {
    get enabled(): cdktf.IResolvable;
    get httpApplicationRoutingZoneName(): string;
}
export declare class DataAzurermKubernetesClusterAddonProfileIngressApplicationGatewayIngressApplicationGatewayIdentity extends cdktf.ComplexComputedList {
    get clientId(): string;
    get objectId(): string;
    get userAssignedIdentityId(): string;
}
export declare class DataAzurermKubernetesClusterAddonProfileIngressApplicationGateway extends cdktf.ComplexComputedList {
    get effectiveGatewayId(): string;
    get enabled(): cdktf.IResolvable;
    get gatewayId(): string;
    get ingressApplicationGatewayIdentity(): cdktf.IResolvable;
    get subnetCidr(): string;
    get subnetId(): string;
}
export declare class DataAzurermKubernetesClusterAddonProfileKubeDashboard extends cdktf.ComplexComputedList {
    get enabled(): cdktf.IResolvable;
}
export declare class DataAzurermKubernetesClusterAddonProfileOmsAgentOmsAgentIdentity extends cdktf.ComplexComputedList {
    get clientId(): string;
    get objectId(): string;
    get userAssignedIdentityId(): string;
}
export declare class DataAzurermKubernetesClusterAddonProfileOmsAgent extends cdktf.ComplexComputedList {
    get enabled(): cdktf.IResolvable;
    get logAnalyticsWorkspaceId(): string;
    get omsAgentIdentity(): cdktf.IResolvable;
}
export declare class DataAzurermKubernetesClusterAddonProfileOpenServiceMesh extends cdktf.ComplexComputedList {
    get enabled(): cdktf.IResolvable;
}
export declare class DataAzurermKubernetesClusterAddonProfile extends cdktf.ComplexComputedList {
    get azureKeyvaultSecretsProvider(): cdktf.IResolvable;
    get azurePolicy(): cdktf.IResolvable;
    get httpApplicationRouting(): cdktf.IResolvable;
    get ingressApplicationGateway(): cdktf.IResolvable;
    get kubeDashboard(): cdktf.IResolvable;
    get omsAgent(): cdktf.IResolvable;
    get openServiceMesh(): cdktf.IResolvable;
}
export declare class DataAzurermKubernetesClusterAgentPoolProfileUpgradeSettings extends cdktf.ComplexComputedList {
    get maxSurge(): string;
}
export declare class DataAzurermKubernetesClusterAgentPoolProfile extends cdktf.ComplexComputedList {
    get availabilityZones(): string[];
    get count(): number;
    get enableAutoScaling(): cdktf.IResolvable;
    get enableNodePublicIp(): cdktf.IResolvable;
    get maxCount(): number;
    get maxPods(): number;
    get minCount(): number;
    get name(): string;
    get nodeLabels(): {
        [key: string]: string;
    };
    get nodePublicIpPrefixId(): string;
    get nodeTaints(): string[];
    get orchestratorVersion(): string;
    get osDiskSizeGb(): number;
    get osType(): string;
    get tags(): {
        [key: string]: string;
    };
    get type(): string;
    get upgradeSettings(): cdktf.IResolvable;
    get vmSize(): string;
    get vnetSubnetId(): string;
    get zones(): string[];
}
export declare class DataAzurermKubernetesClusterAzureActiveDirectoryRoleBasedAccessControl extends cdktf.ComplexComputedList {
    get adminGroupObjectIds(): string[];
    get azureRbacEnabled(): cdktf.IResolvable;
    get clientAppId(): string;
    get managed(): cdktf.IResolvable;
    get serverAppId(): string;
    get tenantId(): string;
}
export declare class DataAzurermKubernetesClusterIdentity extends cdktf.ComplexComputedList {
    get principalId(): string;
    get tenantId(): string;
    get type(): string;
    get userAssignedIdentityId(): string;
}
export declare class DataAzurermKubernetesClusterIngressApplicationGatewayIngressApplicationGatewayIdentity extends cdktf.ComplexComputedList {
    get clientId(): string;
    get objectId(): string;
    get userAssignedIdentityId(): string;
}
export declare class DataAzurermKubernetesClusterIngressApplicationGateway extends cdktf.ComplexComputedList {
    get effectiveGatewayId(): string;
    get gatewayId(): string;
    get gatewayName(): string;
    get ingressApplicationGatewayIdentity(): cdktf.IResolvable;
    get subnetCidr(): string;
    get subnetId(): string;
}
export declare class DataAzurermKubernetesClusterKeyVaultSecretsProviderSecretIdentity extends cdktf.ComplexComputedList {
    get clientId(): string;
    get objectId(): string;
    get userAssignedIdentityId(): string;
}
export declare class DataAzurermKubernetesClusterKeyVaultSecretsProvider extends cdktf.ComplexComputedList {
    get secretIdentity(): cdktf.IResolvable;
    get secretRotationEnabled(): cdktf.IResolvable;
    get secretRotationInterval(): string;
}
export declare class DataAzurermKubernetesClusterKubeAdminConfig extends cdktf.ComplexComputedList {
    get clientCertificate(): string;
    get clientKey(): string;
    get clusterCaCertificate(): string;
    get host(): string;
    get password(): string;
    get username(): string;
}
export declare class DataAzurermKubernetesClusterKubeConfig extends cdktf.ComplexComputedList {
    get clientCertificate(): string;
    get clientKey(): string;
    get clusterCaCertificate(): string;
    get host(): string;
    get password(): string;
    get username(): string;
}
export declare class DataAzurermKubernetesClusterKubeletIdentity extends cdktf.ComplexComputedList {
    get clientId(): string;
    get objectId(): string;
    get userAssignedIdentityId(): string;
}
export declare class DataAzurermKubernetesClusterLinuxProfileSshKey extends cdktf.ComplexComputedList {
    get keyData(): string;
}
export declare class DataAzurermKubernetesClusterLinuxProfile extends cdktf.ComplexComputedList {
    get adminUsername(): string;
    get sshKey(): cdktf.IResolvable;
}
export declare class DataAzurermKubernetesClusterNetworkProfile extends cdktf.ComplexComputedList {
    get dnsServiceIp(): string;
    get dockerBridgeCidr(): string;
    get loadBalancerSku(): string;
    get networkPlugin(): string;
    get networkPolicy(): string;
    get podCidr(): string;
    get serviceCidr(): string;
}
export declare class DataAzurermKubernetesClusterOmsAgentOmsAgentIdentity extends cdktf.ComplexComputedList {
    get clientId(): string;
    get objectId(): string;
    get userAssignedIdentityId(): string;
}
export declare class DataAzurermKubernetesClusterOmsAgent extends cdktf.ComplexComputedList {
    get logAnalyticsWorkspaceId(): string;
    get omsAgentIdentity(): cdktf.IResolvable;
}
export declare class DataAzurermKubernetesClusterRoleBasedAccessControlAzureActiveDirectory extends cdktf.ComplexComputedList {
    get adminGroupObjectIds(): string[];
    get clientAppId(): string;
    get managed(): cdktf.IResolvable;
    get serverAppId(): string;
    get tenantId(): string;
}
export declare class DataAzurermKubernetesClusterRoleBasedAccessControl extends cdktf.ComplexComputedList {
    get azureActiveDirectory(): cdktf.IResolvable;
    get enabled(): cdktf.IResolvable;
}
export declare class DataAzurermKubernetesClusterServicePrincipal extends cdktf.ComplexComputedList {
    get clientId(): string;
}
export declare class DataAzurermKubernetesClusterWindowsProfile extends cdktf.ComplexComputedList {
    get adminUsername(): string;
}
export interface DataAzurermKubernetesClusterTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/kubernetes_cluster#read DataAzurermKubernetesCluster#read}
    */
    readonly read?: string;
}
export declare function dataAzurermKubernetesClusterTimeoutsToTerraform(struct?: DataAzurermKubernetesClusterTimeoutsOutputReference | DataAzurermKubernetesClusterTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermKubernetesClusterTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataAzurermKubernetesClusterTimeouts | undefined;
    set internalValue(value: DataAzurermKubernetesClusterTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/kubernetes_cluster azurerm_kubernetes_cluster}
*/
export declare class DataAzurermKubernetesCluster extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/kubernetes_cluster azurerm_kubernetes_cluster} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermKubernetesClusterConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermKubernetesClusterConfig);
    aciConnectorLinux(index: string): DataAzurermKubernetesClusterAciConnectorLinux;
    addonProfile(index: string): DataAzurermKubernetesClusterAddonProfile;
    agentPoolProfile(index: string): DataAzurermKubernetesClusterAgentPoolProfile;
    get apiServerAuthorizedIpRanges(): string[];
    azureActiveDirectoryRoleBasedAccessControl(index: string): DataAzurermKubernetesClusterAzureActiveDirectoryRoleBasedAccessControl;
    get azurePolicyEnabled(): cdktf.IResolvable;
    get diskEncryptionSetId(): string;
    get dnsPrefix(): string;
    get fqdn(): string;
    get httpApplicationRoutingEnabled(): cdktf.IResolvable;
    get httpApplicationRoutingZoneName(): string;
    get id(): string;
    identity(index: string): DataAzurermKubernetesClusterIdentity;
    ingressApplicationGateway(index: string): DataAzurermKubernetesClusterIngressApplicationGateway;
    keyVaultSecretsProvider(index: string): DataAzurermKubernetesClusterKeyVaultSecretsProvider;
    kubeAdminConfig(index: string): DataAzurermKubernetesClusterKubeAdminConfig;
    get kubeAdminConfigRaw(): string;
    kubeConfig(index: string): DataAzurermKubernetesClusterKubeConfig;
    get kubeConfigRaw(): string;
    kubeletIdentity(index: string): DataAzurermKubernetesClusterKubeletIdentity;
    get kubernetesVersion(): string;
    linuxProfile(index: string): DataAzurermKubernetesClusterLinuxProfile;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    networkProfile(index: string): DataAzurermKubernetesClusterNetworkProfile;
    get nodeResourceGroup(): string;
    omsAgent(index: string): DataAzurermKubernetesClusterOmsAgent;
    get openServiceMeshEnabled(): cdktf.IResolvable;
    get privateClusterEnabled(): cdktf.IResolvable;
    get privateFqdn(): string;
    get privateLinkEnabled(): cdktf.IResolvable;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    roleBasedAccessControl(index: string): DataAzurermKubernetesClusterRoleBasedAccessControl;
    get roleBasedAccessControlEnabled(): cdktf.IResolvable;
    servicePrincipal(index: string): DataAzurermKubernetesClusterServicePrincipal;
    tags(key: string): string | cdktf.IResolvable;
    windowsProfile(index: string): DataAzurermKubernetesClusterWindowsProfile;
    private _timeouts;
    get timeouts(): DataAzurermKubernetesClusterTimeoutsOutputReference;
    putTimeouts(value: DataAzurermKubernetesClusterTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermKubernetesClusterTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
