import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermMonitorLogProfileConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/monitor_log_profile#name DataAzurermMonitorLogProfile#name}
    */
    readonly name: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/monitor_log_profile#timeouts DataAzurermMonitorLogProfile#timeouts}
    */
    readonly timeouts?: DataAzurermMonitorLogProfileTimeouts;
}
export declare class DataAzurermMonitorLogProfileRetentionPolicy extends cdktf.ComplexComputedList {
    get days(): number;
    get enabled(): cdktf.IResolvable;
}
export interface DataAzurermMonitorLogProfileTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/monitor_log_profile#read DataAzurermMonitorLogProfile#read}
    */
    readonly read?: string;
}
export declare function dataAzurermMonitorLogProfileTimeoutsToTerraform(struct?: DataAzurermMonitorLogProfileTimeoutsOutputReference | DataAzurermMonitorLogProfileTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermMonitorLogProfileTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataAzurermMonitorLogProfileTimeouts | undefined;
    set internalValue(value: DataAzurermMonitorLogProfileTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/monitor_log_profile azurerm_monitor_log_profile}
*/
export declare class DataAzurermMonitorLogProfile extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/monitor_log_profile azurerm_monitor_log_profile} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermMonitorLogProfileConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermMonitorLogProfileConfig);
    get categories(): string[];
    get id(): string;
    get locations(): string[];
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    retentionPolicy(index: string): DataAzurermMonitorLogProfileRetentionPolicy;
    get servicebusRuleId(): string;
    get storageAccountId(): string;
    private _timeouts;
    get timeouts(): DataAzurermMonitorLogProfileTimeoutsOutputReference;
    putTimeouts(value: DataAzurermMonitorLogProfileTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermMonitorLogProfileTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
