import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermNetappPoolConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/netapp_pool#account_name DataAzurermNetappPool#account_name}
    */
    readonly accountName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/netapp_pool#name DataAzurermNetappPool#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/netapp_pool#resource_group_name DataAzurermNetappPool#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/netapp_pool#timeouts DataAzurermNetappPool#timeouts}
    */
    readonly timeouts?: DataAzurermNetappPoolTimeouts;
}
export interface DataAzurermNetappPoolTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/netapp_pool#read DataAzurermNetappPool#read}
    */
    readonly read?: string;
}
export declare function dataAzurermNetappPoolTimeoutsToTerraform(struct?: DataAzurermNetappPoolTimeoutsOutputReference | DataAzurermNetappPoolTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermNetappPoolTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataAzurermNetappPoolTimeouts | undefined;
    set internalValue(value: DataAzurermNetappPoolTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/netapp_pool azurerm_netapp_pool}
*/
export declare class DataAzurermNetappPool extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/netapp_pool azurerm_netapp_pool} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermNetappPoolConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermNetappPoolConfig);
    private _accountName?;
    get accountName(): string;
    set accountName(value: string);
    get accountNameInput(): string | undefined;
    get id(): string;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get serviceLevel(): string;
    get sizeInTb(): number;
    private _timeouts;
    get timeouts(): DataAzurermNetappPoolTimeoutsOutputReference;
    putTimeouts(value: DataAzurermNetappPoolTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermNetappPoolTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
