import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermSharedImageVersionsConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/shared_image_versions#gallery_name DataAzurermSharedImageVersions#gallery_name}
    */
    readonly galleryName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/shared_image_versions#image_name DataAzurermSharedImageVersions#image_name}
    */
    readonly imageName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/shared_image_versions#resource_group_name DataAzurermSharedImageVersions#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/shared_image_versions#tags_filter DataAzurermSharedImageVersions#tags_filter}
    */
    readonly tagsFilter?: {
        [key: string]: string;
    };
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/shared_image_versions#timeouts DataAzurermSharedImageVersions#timeouts}
    */
    readonly timeouts?: DataAzurermSharedImageVersionsTimeouts;
}
export declare class DataAzurermSharedImageVersionsImagesTargetRegion extends cdktf.ComplexComputedList {
    get name(): string;
    get regionalReplicaCount(): number;
    get storageAccountType(): string;
}
export declare class DataAzurermSharedImageVersionsImages extends cdktf.ComplexComputedList {
    get excludeFromLatest(): cdktf.IResolvable;
    get location(): string;
    get managedImageId(): string;
    get name(): string;
    get tags(): {
        [key: string]: string;
    };
    get targetRegion(): cdktf.IResolvable;
}
export interface DataAzurermSharedImageVersionsTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/shared_image_versions#read DataAzurermSharedImageVersions#read}
    */
    readonly read?: string;
}
export declare function dataAzurermSharedImageVersionsTimeoutsToTerraform(struct?: DataAzurermSharedImageVersionsTimeoutsOutputReference | DataAzurermSharedImageVersionsTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermSharedImageVersionsTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataAzurermSharedImageVersionsTimeouts | undefined;
    set internalValue(value: DataAzurermSharedImageVersionsTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/shared_image_versions azurerm_shared_image_versions}
*/
export declare class DataAzurermSharedImageVersions extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/shared_image_versions azurerm_shared_image_versions} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermSharedImageVersionsConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermSharedImageVersionsConfig);
    private _galleryName?;
    get galleryName(): string;
    set galleryName(value: string);
    get galleryNameInput(): string | undefined;
    get id(): string;
    private _imageName?;
    get imageName(): string;
    set imageName(value: string);
    get imageNameInput(): string | undefined;
    images(index: string): DataAzurermSharedImageVersionsImages;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _tagsFilter?;
    get tagsFilter(): {
        [key: string]: string;
    };
    set tagsFilter(value: {
        [key: string]: string;
    });
    resetTagsFilter(): void;
    get tagsFilterInput(): {
        [key: string]: string;
    } | undefined;
    private _timeouts;
    get timeouts(): DataAzurermSharedImageVersionsTimeoutsOutputReference;
    putTimeouts(value: DataAzurermSharedImageVersionsTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermSharedImageVersionsTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
