import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermSpringCloudServiceConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/spring_cloud_service#name DataAzurermSpringCloudService#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/spring_cloud_service#resource_group_name DataAzurermSpringCloudService#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/spring_cloud_service#timeouts DataAzurermSpringCloudService#timeouts}
    */
    readonly timeouts?: DataAzurermSpringCloudServiceTimeouts;
}
export declare class DataAzurermSpringCloudServiceConfigServerGitSettingHttpBasicAuth extends cdktf.ComplexComputedList {
    get password(): string;
    get username(): string;
}
export declare class DataAzurermSpringCloudServiceConfigServerGitSettingRepositoryHttpBasicAuth extends cdktf.ComplexComputedList {
    get password(): string;
    get username(): string;
}
export declare class DataAzurermSpringCloudServiceConfigServerGitSettingRepositorySshAuth extends cdktf.ComplexComputedList {
    get hostKey(): string;
    get hostKeyAlgorithm(): string;
    get privateKey(): string;
    get strictHostKeyCheckingEnabled(): cdktf.IResolvable;
}
export declare class DataAzurermSpringCloudServiceConfigServerGitSettingRepository extends cdktf.ComplexComputedList {
    get httpBasicAuth(): cdktf.IResolvable;
    get label(): string;
    get name(): string;
    get pattern(): string[];
    get searchPaths(): string[];
    get sshAuth(): cdktf.IResolvable;
    get uri(): string;
}
export declare class DataAzurermSpringCloudServiceConfigServerGitSettingSshAuth extends cdktf.ComplexComputedList {
    get hostKey(): string;
    get hostKeyAlgorithm(): string;
    get privateKey(): string;
    get strictHostKeyCheckingEnabled(): cdktf.IResolvable;
}
export declare class DataAzurermSpringCloudServiceConfigServerGitSetting extends cdktf.ComplexComputedList {
    get httpBasicAuth(): cdktf.IResolvable;
    get label(): string;
    get repository(): cdktf.IResolvable;
    get searchPaths(): string[];
    get sshAuth(): cdktf.IResolvable;
    get uri(): string;
}
export declare class DataAzurermSpringCloudServiceRequiredNetworkTrafficRules extends cdktf.ComplexComputedList {
    get direction(): string;
    get fqdns(): string[];
    get ipAddresses(): string[];
    get port(): number;
    get protocol(): string;
}
export interface DataAzurermSpringCloudServiceTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/spring_cloud_service#read DataAzurermSpringCloudService#read}
    */
    readonly read?: string;
}
export declare function dataAzurermSpringCloudServiceTimeoutsToTerraform(struct?: DataAzurermSpringCloudServiceTimeoutsOutputReference | DataAzurermSpringCloudServiceTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermSpringCloudServiceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataAzurermSpringCloudServiceTimeouts | undefined;
    set internalValue(value: DataAzurermSpringCloudServiceTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/spring_cloud_service azurerm_spring_cloud_service}
*/
export declare class DataAzurermSpringCloudService extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/spring_cloud_service azurerm_spring_cloud_service} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermSpringCloudServiceConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermSpringCloudServiceConfig);
    configServerGitSetting(index: string): DataAzurermSpringCloudServiceConfigServerGitSetting;
    get id(): string;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get outboundPublicIpAddresses(): string[];
    requiredNetworkTrafficRules(index: string): DataAzurermSpringCloudServiceRequiredNetworkTrafficRules;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    tags(key: string): string | cdktf.IResolvable;
    private _timeouts;
    get timeouts(): DataAzurermSpringCloudServiceTimeoutsOutputReference;
    putTimeouts(value: DataAzurermSpringCloudServiceTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermSpringCloudServiceTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
