import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermStorageManagementPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/storage_management_policy#storage_account_id DataAzurermStorageManagementPolicy#storage_account_id}
    */
    readonly storageAccountId: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/storage_management_policy#timeouts DataAzurermStorageManagementPolicy#timeouts}
    */
    readonly timeouts?: DataAzurermStorageManagementPolicyTimeouts;
}
export declare class DataAzurermStorageManagementPolicyRuleActionsBaseBlob extends cdktf.ComplexComputedList {
    get deleteAfterDaysSinceModificationGreaterThan(): number;
    get tierToArchiveAfterDaysSinceModificationGreaterThan(): number;
    get tierToCoolAfterDaysSinceModificationGreaterThan(): number;
}
export declare class DataAzurermStorageManagementPolicyRuleActionsSnapshot extends cdktf.ComplexComputedList {
    get changeTierToArchiveAfterDaysSinceCreation(): number;
    get changeTierToCoolAfterDaysSinceCreation(): number;
    get deleteAfterDaysSinceCreationGreaterThan(): number;
}
export declare class DataAzurermStorageManagementPolicyRuleActionsVersion extends cdktf.ComplexComputedList {
    get changeTierToArchiveAfterDaysSinceCreation(): number;
    get changeTierToCoolAfterDaysSinceCreation(): number;
    get deleteAfterDaysSinceCreation(): number;
}
export declare class DataAzurermStorageManagementPolicyRuleActions extends cdktf.ComplexComputedList {
    get baseBlob(): cdktf.IResolvable;
    get snapshot(): cdktf.IResolvable;
    get version(): cdktf.IResolvable;
}
export declare class DataAzurermStorageManagementPolicyRuleFiltersMatchBlobIndexTag extends cdktf.ComplexComputedList {
    get name(): string;
    get operation(): string;
    get value(): string;
}
export declare class DataAzurermStorageManagementPolicyRuleFilters extends cdktf.ComplexComputedList {
    get blobTypes(): string[];
    get matchBlobIndexTag(): cdktf.IResolvable;
    get prefixMatch(): string[];
}
export declare class DataAzurermStorageManagementPolicyRule extends cdktf.ComplexComputedList {
    get actions(): cdktf.IResolvable;
    get enabled(): cdktf.IResolvable;
    get filters(): cdktf.IResolvable;
    get name(): string;
}
export interface DataAzurermStorageManagementPolicyTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/storage_management_policy#read DataAzurermStorageManagementPolicy#read}
    */
    readonly read?: string;
}
export declare function dataAzurermStorageManagementPolicyTimeoutsToTerraform(struct?: DataAzurermStorageManagementPolicyTimeoutsOutputReference | DataAzurermStorageManagementPolicyTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermStorageManagementPolicyTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataAzurermStorageManagementPolicyTimeouts | undefined;
    set internalValue(value: DataAzurermStorageManagementPolicyTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/storage_management_policy azurerm_storage_management_policy}
*/
export declare class DataAzurermStorageManagementPolicy extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/storage_management_policy azurerm_storage_management_policy} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermStorageManagementPolicyConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermStorageManagementPolicyConfig);
    get id(): string;
    rule(index: string): DataAzurermStorageManagementPolicyRule;
    private _storageAccountId?;
    get storageAccountId(): string;
    set storageAccountId(value: string);
    get storageAccountIdInput(): string | undefined;
    private _timeouts;
    get timeouts(): DataAzurermStorageManagementPolicyTimeoutsOutputReference;
    putTimeouts(value: DataAzurermStorageManagementPolicyTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermStorageManagementPolicyTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
