import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermStorageSyncConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/storage_sync#name DataAzurermStorageSync#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/storage_sync#resource_group_name DataAzurermStorageSync#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/storage_sync#timeouts DataAzurermStorageSync#timeouts}
    */
    readonly timeouts?: DataAzurermStorageSyncTimeouts;
}
export interface DataAzurermStorageSyncTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/storage_sync#read DataAzurermStorageSync#read}
    */
    readonly read?: string;
}
export declare function dataAzurermStorageSyncTimeoutsToTerraform(struct?: DataAzurermStorageSyncTimeoutsOutputReference | DataAzurermStorageSyncTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermStorageSyncTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataAzurermStorageSyncTimeouts | undefined;
    set internalValue(value: DataAzurermStorageSyncTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/storage_sync azurerm_storage_sync}
*/
export declare class DataAzurermStorageSync extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/storage_sync azurerm_storage_sync} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermStorageSyncConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermStorageSyncConfig);
    get id(): string;
    get incomingTrafficPolicy(): string;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    tags(key: string): string | cdktf.IResolvable;
    private _timeouts;
    get timeouts(): DataAzurermStorageSyncTimeoutsOutputReference;
    putTimeouts(value: DataAzurermStorageSyncTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermStorageSyncTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
