import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermSubnetConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/subnet#name DataAzurermSubnet#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/subnet#resource_group_name DataAzurermSubnet#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/subnet#virtual_network_name DataAzurermSubnet#virtual_network_name}
    */
    readonly virtualNetworkName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/subnet#timeouts DataAzurermSubnet#timeouts}
    */
    readonly timeouts?: DataAzurermSubnetTimeouts;
}
export interface DataAzurermSubnetTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/subnet#read DataAzurermSubnet#read}
    */
    readonly read?: string;
}
export declare function dataAzurermSubnetTimeoutsToTerraform(struct?: DataAzurermSubnetTimeoutsOutputReference | DataAzurermSubnetTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermSubnetTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataAzurermSubnetTimeouts | undefined;
    set internalValue(value: DataAzurermSubnetTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/subnet azurerm_subnet}
*/
export declare class DataAzurermSubnet extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/subnet azurerm_subnet} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermSubnetConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermSubnetConfig);
    get addressPrefix(): string;
    get addressPrefixes(): string[];
    get enforcePrivateLinkEndpointNetworkPolicies(): cdktf.IResolvable;
    get enforcePrivateLinkServiceNetworkPolicies(): cdktf.IResolvable;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get networkSecurityGroupId(): string;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get routeTableId(): string;
    get serviceEndpoints(): string[];
    private _virtualNetworkName?;
    get virtualNetworkName(): string;
    set virtualNetworkName(value: string);
    get virtualNetworkNameInput(): string | undefined;
    private _timeouts;
    get timeouts(): DataAzurermSubnetTimeoutsOutputReference;
    putTimeouts(value: DataAzurermSubnetTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermSubnetTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
