import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataFactoryPipelineConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_pipeline#activities_json DataFactoryPipeline#activities_json}
    */
    readonly activitiesJson?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_pipeline#annotations DataFactoryPipeline#annotations}
    */
    readonly annotations?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_pipeline#concurrency DataFactoryPipeline#concurrency}
    */
    readonly concurrency?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_pipeline#data_factory_id DataFactoryPipeline#data_factory_id}
    */
    readonly dataFactoryId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_pipeline#data_factory_name DataFactoryPipeline#data_factory_name}
    */
    readonly dataFactoryName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_pipeline#description DataFactoryPipeline#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_pipeline#folder DataFactoryPipeline#folder}
    */
    readonly folder?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_pipeline#moniter_metrics_after_duration DataFactoryPipeline#moniter_metrics_after_duration}
    */
    readonly moniterMetricsAfterDuration?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_pipeline#name DataFactoryPipeline#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_pipeline#parameters DataFactoryPipeline#parameters}
    */
    readonly parameters?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_pipeline#resource_group_name DataFactoryPipeline#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_pipeline#variables DataFactoryPipeline#variables}
    */
    readonly variables?: {
        [key: string]: string;
    };
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_pipeline#timeouts DataFactoryPipeline#timeouts}
    */
    readonly timeouts?: DataFactoryPipelineTimeouts;
}
export interface DataFactoryPipelineTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_pipeline#create DataFactoryPipeline#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_pipeline#delete DataFactoryPipeline#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_pipeline#read DataFactoryPipeline#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_pipeline#update DataFactoryPipeline#update}
    */
    readonly update?: string;
}
export declare function dataFactoryPipelineTimeoutsToTerraform(struct?: DataFactoryPipelineTimeoutsOutputReference | DataFactoryPipelineTimeouts | cdktf.IResolvable): any;
export declare class DataFactoryPipelineTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataFactoryPipelineTimeouts | undefined;
    set internalValue(value: DataFactoryPipelineTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_pipeline azurerm_data_factory_pipeline}
*/
export declare class DataFactoryPipeline extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_pipeline azurerm_data_factory_pipeline} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataFactoryPipelineConfig
    */
    constructor(scope: Construct, id: string, config: DataFactoryPipelineConfig);
    private _activitiesJson?;
    get activitiesJson(): string;
    set activitiesJson(value: string);
    resetActivitiesJson(): void;
    get activitiesJsonInput(): string | undefined;
    private _annotations?;
    get annotations(): string[];
    set annotations(value: string[]);
    resetAnnotations(): void;
    get annotationsInput(): string[] | undefined;
    private _concurrency?;
    get concurrency(): number;
    set concurrency(value: number);
    resetConcurrency(): void;
    get concurrencyInput(): number | undefined;
    private _dataFactoryId?;
    get dataFactoryId(): string;
    set dataFactoryId(value: string);
    resetDataFactoryId(): void;
    get dataFactoryIdInput(): string | undefined;
    private _dataFactoryName?;
    get dataFactoryName(): string;
    set dataFactoryName(value: string);
    resetDataFactoryName(): void;
    get dataFactoryNameInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _folder?;
    get folder(): string;
    set folder(value: string);
    resetFolder(): void;
    get folderInput(): string | undefined;
    get id(): string;
    private _moniterMetricsAfterDuration?;
    get moniterMetricsAfterDuration(): string;
    set moniterMetricsAfterDuration(value: string);
    resetMoniterMetricsAfterDuration(): void;
    get moniterMetricsAfterDurationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _parameters?;
    get parameters(): {
        [key: string]: string;
    };
    set parameters(value: {
        [key: string]: string;
    });
    resetParameters(): void;
    get parametersInput(): {
        [key: string]: string;
    } | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _variables?;
    get variables(): {
        [key: string]: string;
    };
    set variables(value: {
        [key: string]: string;
    });
    resetVariables(): void;
    get variablesInput(): {
        [key: string]: string;
    } | undefined;
    private _timeouts;
    get timeouts(): DataFactoryPipelineTimeoutsOutputReference;
    putTimeouts(value: DataFactoryPipelineTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataFactoryPipelineTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
