import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface KeyVaultAccessPolicyAConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault_access_policy#application_id KeyVaultAccessPolicyA#application_id}
    */
    readonly applicationId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault_access_policy#certificate_permissions KeyVaultAccessPolicyA#certificate_permissions}
    */
    readonly certificatePermissions?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault_access_policy#key_permissions KeyVaultAccessPolicyA#key_permissions}
    */
    readonly keyPermissions?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault_access_policy#key_vault_id KeyVaultAccessPolicyA#key_vault_id}
    */
    readonly keyVaultId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault_access_policy#object_id KeyVaultAccessPolicyA#object_id}
    */
    readonly objectId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault_access_policy#secret_permissions KeyVaultAccessPolicyA#secret_permissions}
    */
    readonly secretPermissions?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault_access_policy#storage_permissions KeyVaultAccessPolicyA#storage_permissions}
    */
    readonly storagePermissions?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault_access_policy#tenant_id KeyVaultAccessPolicyA#tenant_id}
    */
    readonly tenantId: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault_access_policy#timeouts KeyVaultAccessPolicyA#timeouts}
    */
    readonly timeouts?: KeyVaultAccessPolicyTimeouts;
}
export interface KeyVaultAccessPolicyTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault_access_policy#create KeyVaultAccessPolicyA#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault_access_policy#delete KeyVaultAccessPolicyA#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault_access_policy#read KeyVaultAccessPolicyA#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault_access_policy#update KeyVaultAccessPolicyA#update}
    */
    readonly update?: string;
}
export declare function keyVaultAccessPolicyTimeoutsToTerraform(struct?: KeyVaultAccessPolicyTimeoutsOutputReference | KeyVaultAccessPolicyTimeouts | cdktf.IResolvable): any;
export declare class KeyVaultAccessPolicyTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): KeyVaultAccessPolicyTimeouts | undefined;
    set internalValue(value: KeyVaultAccessPolicyTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault_access_policy azurerm_key_vault_access_policy}
*/
export declare class KeyVaultAccessPolicyA extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault_access_policy azurerm_key_vault_access_policy} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options KeyVaultAccessPolicyAConfig
    */
    constructor(scope: Construct, id: string, config: KeyVaultAccessPolicyAConfig);
    private _applicationId?;
    get applicationId(): string;
    set applicationId(value: string);
    resetApplicationId(): void;
    get applicationIdInput(): string | undefined;
    private _certificatePermissions?;
    get certificatePermissions(): string[];
    set certificatePermissions(value: string[]);
    resetCertificatePermissions(): void;
    get certificatePermissionsInput(): string[] | undefined;
    get id(): string;
    private _keyPermissions?;
    get keyPermissions(): string[];
    set keyPermissions(value: string[]);
    resetKeyPermissions(): void;
    get keyPermissionsInput(): string[] | undefined;
    private _keyVaultId?;
    get keyVaultId(): string;
    set keyVaultId(value: string);
    get keyVaultIdInput(): string | undefined;
    private _objectId?;
    get objectId(): string;
    set objectId(value: string);
    get objectIdInput(): string | undefined;
    private _secretPermissions?;
    get secretPermissions(): string[];
    set secretPermissions(value: string[]);
    resetSecretPermissions(): void;
    get secretPermissionsInput(): string[] | undefined;
    private _storagePermissions?;
    get storagePermissions(): string[];
    set storagePermissions(value: string[]);
    resetStoragePermissions(): void;
    get storagePermissionsInput(): string[] | undefined;
    private _tenantId?;
    get tenantId(): string;
    set tenantId(value: string);
    get tenantIdInput(): string | undefined;
    private _timeouts;
    get timeouts(): KeyVaultAccessPolicyTimeoutsOutputReference;
    putTimeouts(value: KeyVaultAccessPolicyTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): KeyVaultAccessPolicyTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
