import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface LogicAppStandardConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_standard#app_service_plan_id LogicAppStandard#app_service_plan_id}
    */
    readonly appServicePlanId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_standard#app_settings LogicAppStandard#app_settings}
    */
    readonly appSettings?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_standard#bundle_version LogicAppStandard#bundle_version}
    */
    readonly bundleVersion?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_standard#client_affinity_enabled LogicAppStandard#client_affinity_enabled}
    */
    readonly clientAffinityEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_standard#client_certificate_mode LogicAppStandard#client_certificate_mode}
    */
    readonly clientCertificateMode?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_standard#enabled LogicAppStandard#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_standard#https_only LogicAppStandard#https_only}
    */
    readonly httpsOnly?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_standard#location LogicAppStandard#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_standard#name LogicAppStandard#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_standard#resource_group_name LogicAppStandard#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_standard#storage_account_access_key LogicAppStandard#storage_account_access_key}
    */
    readonly storageAccountAccessKey: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_standard#storage_account_name LogicAppStandard#storage_account_name}
    */
    readonly storageAccountName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_standard#storage_account_share_name LogicAppStandard#storage_account_share_name}
    */
    readonly storageAccountShareName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_standard#tags LogicAppStandard#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_standard#use_extension_bundle LogicAppStandard#use_extension_bundle}
    */
    readonly useExtensionBundle?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_standard#version LogicAppStandard#version}
    */
    readonly version?: string;
    /**
    * connection_string block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_standard#connection_string LogicAppStandard#connection_string}
    */
    readonly connectionString?: LogicAppStandardConnectionString[] | cdktf.IResolvable;
    /**
    * identity block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_standard#identity LogicAppStandard#identity}
    */
    readonly identity?: LogicAppStandardIdentity;
    /**
    * site_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_standard#site_config LogicAppStandard#site_config}
    */
    readonly siteConfig?: LogicAppStandardSiteConfig;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_standard#timeouts LogicAppStandard#timeouts}
    */
    readonly timeouts?: LogicAppStandardTimeouts;
}
export declare class LogicAppStandardSiteCredential extends cdktf.ComplexComputedList {
    get password(): string;
    get username(): string;
}
export interface LogicAppStandardConnectionString {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_standard#name LogicAppStandard#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_standard#type LogicAppStandard#type}
    */
    readonly type: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_standard#value LogicAppStandard#value}
    */
    readonly value: string;
}
export declare function logicAppStandardConnectionStringToTerraform(struct?: LogicAppStandardConnectionString | cdktf.IResolvable): any;
export interface LogicAppStandardIdentity {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_standard#type LogicAppStandard#type}
    */
    readonly type: string;
}
export declare function logicAppStandardIdentityToTerraform(struct?: LogicAppStandardIdentityOutputReference | LogicAppStandardIdentity): any;
export declare class LogicAppStandardIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): LogicAppStandardIdentity | undefined;
    set internalValue(value: LogicAppStandardIdentity | undefined);
    get principalId(): string;
    get tenantId(): string;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface LogicAppStandardSiteConfigIpRestrictionHeaders {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_standard#x_azure_fdid LogicAppStandard#x_azure_fdid}
    */
    readonly xAzureFdid?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_standard#x_fd_health_probe LogicAppStandard#x_fd_health_probe}
    */
    readonly xFdHealthProbe?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_standard#x_forwarded_for LogicAppStandard#x_forwarded_for}
    */
    readonly xForwardedFor?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_standard#x_forwarded_host LogicAppStandard#x_forwarded_host}
    */
    readonly xForwardedHost?: string[];
}
export declare function logicAppStandardSiteConfigIpRestrictionHeadersToTerraform(struct?: LogicAppStandardSiteConfigIpRestrictionHeaders | cdktf.IResolvable): any;
export interface LogicAppStandardSiteConfigIpRestriction {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_standard#action LogicAppStandard#action}
    */
    readonly action?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_standard#headers LogicAppStandard#headers}
    */
    readonly headers?: LogicAppStandardSiteConfigIpRestrictionHeaders[] | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_standard#ip_address LogicAppStandard#ip_address}
    */
    readonly ipAddress?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_standard#name LogicAppStandard#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_standard#priority LogicAppStandard#priority}
    */
    readonly priority?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_standard#service_tag LogicAppStandard#service_tag}
    */
    readonly serviceTag?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_standard#virtual_network_subnet_id LogicAppStandard#virtual_network_subnet_id}
    */
    readonly virtualNetworkSubnetId?: string;
}
export declare function logicAppStandardSiteConfigIpRestrictionToTerraform(struct?: LogicAppStandardSiteConfigIpRestriction | cdktf.IResolvable): any;
export interface LogicAppStandardSiteConfigCors {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_standard#allowed_origins LogicAppStandard#allowed_origins}
    */
    readonly allowedOrigins: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_standard#support_credentials LogicAppStandard#support_credentials}
    */
    readonly supportCredentials?: boolean | cdktf.IResolvable;
}
export declare function logicAppStandardSiteConfigCorsToTerraform(struct?: LogicAppStandardSiteConfigCorsOutputReference | LogicAppStandardSiteConfigCors): any;
export declare class LogicAppStandardSiteConfigCorsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): LogicAppStandardSiteConfigCors | undefined;
    set internalValue(value: LogicAppStandardSiteConfigCors | undefined);
    private _allowedOrigins?;
    get allowedOrigins(): string[];
    set allowedOrigins(value: string[]);
    get allowedOriginsInput(): string[] | undefined;
    private _supportCredentials?;
    get supportCredentials(): boolean | cdktf.IResolvable;
    set supportCredentials(value: boolean | cdktf.IResolvable);
    resetSupportCredentials(): void;
    get supportCredentialsInput(): boolean | cdktf.IResolvable | undefined;
}
export interface LogicAppStandardSiteConfig {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_standard#always_on LogicAppStandard#always_on}
    */
    readonly alwaysOn?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_standard#app_scale_limit LogicAppStandard#app_scale_limit}
    */
    readonly appScaleLimit?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_standard#dotnet_framework_version LogicAppStandard#dotnet_framework_version}
    */
    readonly dotnetFrameworkVersion?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_standard#elastic_instance_minimum LogicAppStandard#elastic_instance_minimum}
    */
    readonly elasticInstanceMinimum?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_standard#ftps_state LogicAppStandard#ftps_state}
    */
    readonly ftpsState?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_standard#health_check_path LogicAppStandard#health_check_path}
    */
    readonly healthCheckPath?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_standard#http2_enabled LogicAppStandard#http2_enabled}
    */
    readonly http2Enabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_standard#ip_restriction LogicAppStandard#ip_restriction}
    */
    readonly ipRestriction?: LogicAppStandardSiteConfigIpRestriction[] | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_standard#linux_fx_version LogicAppStandard#linux_fx_version}
    */
    readonly linuxFxVersion?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_standard#min_tls_version LogicAppStandard#min_tls_version}
    */
    readonly minTlsVersion?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_standard#pre_warmed_instance_count LogicAppStandard#pre_warmed_instance_count}
    */
    readonly preWarmedInstanceCount?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_standard#runtime_scale_monitoring_enabled LogicAppStandard#runtime_scale_monitoring_enabled}
    */
    readonly runtimeScaleMonitoringEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_standard#use_32_bit_worker_process LogicAppStandard#use_32_bit_worker_process}
    */
    readonly use32BitWorkerProcess?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_standard#vnet_route_all_enabled LogicAppStandard#vnet_route_all_enabled}
    */
    readonly vnetRouteAllEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_standard#websockets_enabled LogicAppStandard#websockets_enabled}
    */
    readonly websocketsEnabled?: boolean | cdktf.IResolvable;
    /**
    * cors block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_standard#cors LogicAppStandard#cors}
    */
    readonly cors?: LogicAppStandardSiteConfigCors;
}
export declare function logicAppStandardSiteConfigToTerraform(struct?: LogicAppStandardSiteConfigOutputReference | LogicAppStandardSiteConfig): any;
export declare class LogicAppStandardSiteConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): LogicAppStandardSiteConfig | undefined;
    set internalValue(value: LogicAppStandardSiteConfig | undefined);
    private _alwaysOn?;
    get alwaysOn(): boolean | cdktf.IResolvable;
    set alwaysOn(value: boolean | cdktf.IResolvable);
    resetAlwaysOn(): void;
    get alwaysOnInput(): boolean | cdktf.IResolvable | undefined;
    private _appScaleLimit?;
    get appScaleLimit(): number;
    set appScaleLimit(value: number);
    resetAppScaleLimit(): void;
    get appScaleLimitInput(): number | undefined;
    private _dotnetFrameworkVersion?;
    get dotnetFrameworkVersion(): string;
    set dotnetFrameworkVersion(value: string);
    resetDotnetFrameworkVersion(): void;
    get dotnetFrameworkVersionInput(): string | undefined;
    private _elasticInstanceMinimum?;
    get elasticInstanceMinimum(): number;
    set elasticInstanceMinimum(value: number);
    resetElasticInstanceMinimum(): void;
    get elasticInstanceMinimumInput(): number | undefined;
    private _ftpsState?;
    get ftpsState(): string;
    set ftpsState(value: string);
    resetFtpsState(): void;
    get ftpsStateInput(): string | undefined;
    private _healthCheckPath?;
    get healthCheckPath(): string;
    set healthCheckPath(value: string);
    resetHealthCheckPath(): void;
    get healthCheckPathInput(): string | undefined;
    private _http2Enabled?;
    get http2Enabled(): boolean | cdktf.IResolvable;
    set http2Enabled(value: boolean | cdktf.IResolvable);
    resetHttp2Enabled(): void;
    get http2EnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _ipRestriction?;
    get ipRestriction(): LogicAppStandardSiteConfigIpRestriction[] | cdktf.IResolvable;
    set ipRestriction(value: LogicAppStandardSiteConfigIpRestriction[] | cdktf.IResolvable);
    resetIpRestriction(): void;
    get ipRestrictionInput(): cdktf.IResolvable | LogicAppStandardSiteConfigIpRestriction[] | undefined;
    private _linuxFxVersion?;
    get linuxFxVersion(): string;
    set linuxFxVersion(value: string);
    resetLinuxFxVersion(): void;
    get linuxFxVersionInput(): string | undefined;
    private _minTlsVersion?;
    get minTlsVersion(): string;
    set minTlsVersion(value: string);
    resetMinTlsVersion(): void;
    get minTlsVersionInput(): string | undefined;
    private _preWarmedInstanceCount?;
    get preWarmedInstanceCount(): number;
    set preWarmedInstanceCount(value: number);
    resetPreWarmedInstanceCount(): void;
    get preWarmedInstanceCountInput(): number | undefined;
    private _runtimeScaleMonitoringEnabled?;
    get runtimeScaleMonitoringEnabled(): boolean | cdktf.IResolvable;
    set runtimeScaleMonitoringEnabled(value: boolean | cdktf.IResolvable);
    resetRuntimeScaleMonitoringEnabled(): void;
    get runtimeScaleMonitoringEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _use32BitWorkerProcess?;
    get use32BitWorkerProcess(): boolean | cdktf.IResolvable;
    set use32BitWorkerProcess(value: boolean | cdktf.IResolvable);
    resetUse32BitWorkerProcess(): void;
    get use32BitWorkerProcessInput(): boolean | cdktf.IResolvable | undefined;
    private _vnetRouteAllEnabled?;
    get vnetRouteAllEnabled(): boolean | cdktf.IResolvable;
    set vnetRouteAllEnabled(value: boolean | cdktf.IResolvable);
    resetVnetRouteAllEnabled(): void;
    get vnetRouteAllEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _websocketsEnabled?;
    get websocketsEnabled(): boolean | cdktf.IResolvable;
    set websocketsEnabled(value: boolean | cdktf.IResolvable);
    resetWebsocketsEnabled(): void;
    get websocketsEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _cors;
    get cors(): LogicAppStandardSiteConfigCorsOutputReference;
    putCors(value: LogicAppStandardSiteConfigCors): void;
    resetCors(): void;
    get corsInput(): LogicAppStandardSiteConfigCors | undefined;
}
export interface LogicAppStandardTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_standard#create LogicAppStandard#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_standard#delete LogicAppStandard#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_standard#read LogicAppStandard#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_standard#update LogicAppStandard#update}
    */
    readonly update?: string;
}
export declare function logicAppStandardTimeoutsToTerraform(struct?: LogicAppStandardTimeoutsOutputReference | LogicAppStandardTimeouts | cdktf.IResolvable): any;
export declare class LogicAppStandardTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): LogicAppStandardTimeouts | undefined;
    set internalValue(value: LogicAppStandardTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_standard azurerm_logic_app_standard}
*/
export declare class LogicAppStandard extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_standard azurerm_logic_app_standard} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options LogicAppStandardConfig
    */
    constructor(scope: Construct, id: string, config: LogicAppStandardConfig);
    private _appServicePlanId?;
    get appServicePlanId(): string;
    set appServicePlanId(value: string);
    get appServicePlanIdInput(): string | undefined;
    private _appSettings?;
    get appSettings(): {
        [key: string]: string;
    };
    set appSettings(value: {
        [key: string]: string;
    });
    resetAppSettings(): void;
    get appSettingsInput(): {
        [key: string]: string;
    } | undefined;
    private _bundleVersion?;
    get bundleVersion(): string;
    set bundleVersion(value: string);
    resetBundleVersion(): void;
    get bundleVersionInput(): string | undefined;
    private _clientAffinityEnabled?;
    get clientAffinityEnabled(): boolean | cdktf.IResolvable;
    set clientAffinityEnabled(value: boolean | cdktf.IResolvable);
    resetClientAffinityEnabled(): void;
    get clientAffinityEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _clientCertificateMode?;
    get clientCertificateMode(): string;
    set clientCertificateMode(value: string);
    resetClientCertificateMode(): void;
    get clientCertificateModeInput(): string | undefined;
    get customDomainVerificationId(): string;
    get defaultHostname(): string;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _httpsOnly?;
    get httpsOnly(): boolean | cdktf.IResolvable;
    set httpsOnly(value: boolean | cdktf.IResolvable);
    resetHttpsOnly(): void;
    get httpsOnlyInput(): boolean | cdktf.IResolvable | undefined;
    get id(): string;
    get kind(): string;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get outboundIpAddresses(): string;
    get possibleOutboundIpAddresses(): string;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    siteCredential(index: string): LogicAppStandardSiteCredential;
    private _storageAccountAccessKey?;
    get storageAccountAccessKey(): string;
    set storageAccountAccessKey(value: string);
    get storageAccountAccessKeyInput(): string | undefined;
    private _storageAccountName?;
    get storageAccountName(): string;
    set storageAccountName(value: string);
    get storageAccountNameInput(): string | undefined;
    private _storageAccountShareName?;
    get storageAccountShareName(): string;
    set storageAccountShareName(value: string);
    resetStorageAccountShareName(): void;
    get storageAccountShareNameInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _useExtensionBundle?;
    get useExtensionBundle(): boolean | cdktf.IResolvable;
    set useExtensionBundle(value: boolean | cdktf.IResolvable);
    resetUseExtensionBundle(): void;
    get useExtensionBundleInput(): boolean | cdktf.IResolvable | undefined;
    private _version?;
    get version(): string;
    set version(value: string);
    resetVersion(): void;
    get versionInput(): string | undefined;
    private _connectionString?;
    get connectionString(): LogicAppStandardConnectionString[] | cdktf.IResolvable;
    set connectionString(value: LogicAppStandardConnectionString[] | cdktf.IResolvable);
    resetConnectionString(): void;
    get connectionStringInput(): cdktf.IResolvable | LogicAppStandardConnectionString[] | undefined;
    private _identity;
    get identity(): LogicAppStandardIdentityOutputReference;
    putIdentity(value: LogicAppStandardIdentity): void;
    resetIdentity(): void;
    get identityInput(): LogicAppStandardIdentity | undefined;
    private _siteConfig;
    get siteConfig(): LogicAppStandardSiteConfigOutputReference;
    putSiteConfig(value: LogicAppStandardSiteConfig): void;
    resetSiteConfig(): void;
    get siteConfigInput(): LogicAppStandardSiteConfig | undefined;
    private _timeouts;
    get timeouts(): LogicAppStandardTimeoutsOutputReference;
    putTimeouts(value: LogicAppStandardTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): LogicAppStandardTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
