"use strict";
var _a, _b, _c, _d, _e, _f;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MediaContentKeyPolicy = exports.MediaContentKeyPolicyTimeoutsOutputReference = exports.mediaContentKeyPolicyTimeoutsToTerraform = exports.mediaContentKeyPolicyPolicyOptionToTerraform = exports.MediaContentKeyPolicyPolicyOptionTokenRestrictionOutputReference = exports.mediaContentKeyPolicyPolicyOptionTokenRestrictionToTerraform = exports.mediaContentKeyPolicyPolicyOptionTokenRestrictionRequiredClaimToTerraform = exports.mediaContentKeyPolicyPolicyOptionPlayreadyConfigurationLicenseToTerraform = exports.MediaContentKeyPolicyPolicyOptionPlayreadyConfigurationLicensePlayRightOutputReference = exports.mediaContentKeyPolicyPolicyOptionPlayreadyConfigurationLicensePlayRightToTerraform = exports.MediaContentKeyPolicyPolicyOptionFairplayConfigurationOutputReference = exports.mediaContentKeyPolicyPolicyOptionFairplayConfigurationToTerraform = exports.MediaContentKeyPolicyPolicyOptionFairplayConfigurationOfflineRentalConfigurationOutputReference = exports.mediaContentKeyPolicyPolicyOptionFairplayConfigurationOfflineRentalConfigurationToTerraform = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
function mediaContentKeyPolicyPolicyOptionFairplayConfigurationOfflineRentalConfigurationToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        playback_duration_seconds: cdktf.numberToTerraform(struct.playbackDurationSeconds),
        storage_duration_seconds: cdktf.numberToTerraform(struct.storageDurationSeconds),
    };
}
exports.mediaContentKeyPolicyPolicyOptionFairplayConfigurationOfflineRentalConfigurationToTerraform = mediaContentKeyPolicyPolicyOptionFairplayConfigurationOfflineRentalConfigurationToTerraform;
class MediaContentKeyPolicyPolicyOptionFairplayConfigurationOfflineRentalConfigurationOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource, terraformAttribute, isSingleItem) {
        super(terraformResource, terraformAttribute, isSingleItem);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._playbackDurationSeconds !== undefined) {
            hasAnyValues = true;
            internalValueResult.playbackDurationSeconds = this._playbackDurationSeconds;
        }
        if (this._storageDurationSeconds !== undefined) {
            hasAnyValues = true;
            internalValueResult.storageDurationSeconds = this._storageDurationSeconds;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._playbackDurationSeconds = undefined;
            this._storageDurationSeconds = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._playbackDurationSeconds = value.playbackDurationSeconds;
            this._storageDurationSeconds = value.storageDurationSeconds;
        }
    }
    get playbackDurationSeconds() {
        return this.getNumberAttribute('playback_duration_seconds');
    }
    set playbackDurationSeconds(value) {
        this._playbackDurationSeconds = value;
    }
    resetPlaybackDurationSeconds() {
        this._playbackDurationSeconds = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get playbackDurationSecondsInput() {
        return this._playbackDurationSeconds;
    }
    get storageDurationSeconds() {
        return this.getNumberAttribute('storage_duration_seconds');
    }
    set storageDurationSeconds(value) {
        this._storageDurationSeconds = value;
    }
    resetStorageDurationSeconds() {
        this._storageDurationSeconds = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get storageDurationSecondsInput() {
        return this._storageDurationSeconds;
    }
}
exports.MediaContentKeyPolicyPolicyOptionFairplayConfigurationOfflineRentalConfigurationOutputReference = MediaContentKeyPolicyPolicyOptionFairplayConfigurationOfflineRentalConfigurationOutputReference;
_a = JSII_RTTI_SYMBOL_1;
MediaContentKeyPolicyPolicyOptionFairplayConfigurationOfflineRentalConfigurationOutputReference[_a] = { fqn: "@cdktf/provider-azurerm.MediaContentKeyPolicyPolicyOptionFairplayConfigurationOfflineRentalConfigurationOutputReference", version: "0.5.58" };
function mediaContentKeyPolicyPolicyOptionFairplayConfigurationToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        ask: cdktf.stringToTerraform(struct.ask),
        pfx: cdktf.stringToTerraform(struct.pfx),
        pfx_password: cdktf.stringToTerraform(struct.pfxPassword),
        rental_and_lease_key_type: cdktf.stringToTerraform(struct.rentalAndLeaseKeyType),
        rental_duration_seconds: cdktf.numberToTerraform(struct.rentalDurationSeconds),
        offline_rental_configuration: mediaContentKeyPolicyPolicyOptionFairplayConfigurationOfflineRentalConfigurationToTerraform(struct.offlineRentalConfiguration),
    };
}
exports.mediaContentKeyPolicyPolicyOptionFairplayConfigurationToTerraform = mediaContentKeyPolicyPolicyOptionFairplayConfigurationToTerraform;
class MediaContentKeyPolicyPolicyOptionFairplayConfigurationOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource, terraformAttribute, isSingleItem) {
        super(terraformResource, terraformAttribute, isSingleItem);
        this.isEmptyObject = false;
        // offline_rental_configuration - computed: false, optional: true, required: false
        this._offlineRentalConfiguration = new MediaContentKeyPolicyPolicyOptionFairplayConfigurationOfflineRentalConfigurationOutputReference(this, "offline_rental_configuration", true);
    }
    get internalValue() {
        var _g, _h;
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._ask !== undefined) {
            hasAnyValues = true;
            internalValueResult.ask = this._ask;
        }
        if (this._pfx !== undefined) {
            hasAnyValues = true;
            internalValueResult.pfx = this._pfx;
        }
        if (this._pfxPassword !== undefined) {
            hasAnyValues = true;
            internalValueResult.pfxPassword = this._pfxPassword;
        }
        if (this._rentalAndLeaseKeyType !== undefined) {
            hasAnyValues = true;
            internalValueResult.rentalAndLeaseKeyType = this._rentalAndLeaseKeyType;
        }
        if (this._rentalDurationSeconds !== undefined) {
            hasAnyValues = true;
            internalValueResult.rentalDurationSeconds = this._rentalDurationSeconds;
        }
        if (((_g = this._offlineRentalConfiguration) === null || _g === void 0 ? void 0 : _g.internalValue) !== undefined) {
            hasAnyValues = true;
            internalValueResult.offlineRentalConfiguration = (_h = this._offlineRentalConfiguration) === null || _h === void 0 ? void 0 : _h.internalValue;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._ask = undefined;
            this._pfx = undefined;
            this._pfxPassword = undefined;
            this._rentalAndLeaseKeyType = undefined;
            this._rentalDurationSeconds = undefined;
            this._offlineRentalConfiguration.internalValue = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._ask = value.ask;
            this._pfx = value.pfx;
            this._pfxPassword = value.pfxPassword;
            this._rentalAndLeaseKeyType = value.rentalAndLeaseKeyType;
            this._rentalDurationSeconds = value.rentalDurationSeconds;
            this._offlineRentalConfiguration.internalValue = value.offlineRentalConfiguration;
        }
    }
    get ask() {
        return this.getStringAttribute('ask');
    }
    set ask(value) {
        this._ask = value;
    }
    resetAsk() {
        this._ask = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get askInput() {
        return this._ask;
    }
    get pfx() {
        return this.getStringAttribute('pfx');
    }
    set pfx(value) {
        this._pfx = value;
    }
    resetPfx() {
        this._pfx = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get pfxInput() {
        return this._pfx;
    }
    get pfxPassword() {
        return this.getStringAttribute('pfx_password');
    }
    set pfxPassword(value) {
        this._pfxPassword = value;
    }
    resetPfxPassword() {
        this._pfxPassword = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get pfxPasswordInput() {
        return this._pfxPassword;
    }
    get rentalAndLeaseKeyType() {
        return this.getStringAttribute('rental_and_lease_key_type');
    }
    set rentalAndLeaseKeyType(value) {
        this._rentalAndLeaseKeyType = value;
    }
    resetRentalAndLeaseKeyType() {
        this._rentalAndLeaseKeyType = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get rentalAndLeaseKeyTypeInput() {
        return this._rentalAndLeaseKeyType;
    }
    get rentalDurationSeconds() {
        return this.getNumberAttribute('rental_duration_seconds');
    }
    set rentalDurationSeconds(value) {
        this._rentalDurationSeconds = value;
    }
    resetRentalDurationSeconds() {
        this._rentalDurationSeconds = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get rentalDurationSecondsInput() {
        return this._rentalDurationSeconds;
    }
    get offlineRentalConfiguration() {
        return this._offlineRentalConfiguration;
    }
    putOfflineRentalConfiguration(value) {
        this._offlineRentalConfiguration.internalValue = value;
    }
    resetOfflineRentalConfiguration() {
        this._offlineRentalConfiguration.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get offlineRentalConfigurationInput() {
        return this._offlineRentalConfiguration.internalValue;
    }
}
exports.MediaContentKeyPolicyPolicyOptionFairplayConfigurationOutputReference = MediaContentKeyPolicyPolicyOptionFairplayConfigurationOutputReference;
_b = JSII_RTTI_SYMBOL_1;
MediaContentKeyPolicyPolicyOptionFairplayConfigurationOutputReference[_b] = { fqn: "@cdktf/provider-azurerm.MediaContentKeyPolicyPolicyOptionFairplayConfigurationOutputReference", version: "0.5.58" };
function mediaContentKeyPolicyPolicyOptionPlayreadyConfigurationLicensePlayRightToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        agc_and_color_stripe_restriction: cdktf.numberToTerraform(struct.agcAndColorStripeRestriction),
        allow_passing_video_content_to_unknown_output: cdktf.stringToTerraform(struct.allowPassingVideoContentToUnknownOutput),
        analog_video_opl: cdktf.numberToTerraform(struct.analogVideoOpl),
        compressed_digital_audio_opl: cdktf.numberToTerraform(struct.compressedDigitalAudioOpl),
        digital_video_only_content_restriction: cdktf.booleanToTerraform(struct.digitalVideoOnlyContentRestriction),
        first_play_expiration: cdktf.stringToTerraform(struct.firstPlayExpiration),
        image_constraint_for_analog_component_video_restriction: cdktf.booleanToTerraform(struct.imageConstraintForAnalogComponentVideoRestriction),
        image_constraint_for_analog_computer_monitor_restriction: cdktf.booleanToTerraform(struct.imageConstraintForAnalogComputerMonitorRestriction),
        scms_restriction: cdktf.numberToTerraform(struct.scmsRestriction),
        uncompressed_digital_audio_opl: cdktf.numberToTerraform(struct.uncompressedDigitalAudioOpl),
        uncompressed_digital_video_opl: cdktf.numberToTerraform(struct.uncompressedDigitalVideoOpl),
    };
}
exports.mediaContentKeyPolicyPolicyOptionPlayreadyConfigurationLicensePlayRightToTerraform = mediaContentKeyPolicyPolicyOptionPlayreadyConfigurationLicensePlayRightToTerraform;
class MediaContentKeyPolicyPolicyOptionPlayreadyConfigurationLicensePlayRightOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource, terraformAttribute, isSingleItem) {
        super(terraformResource, terraformAttribute, isSingleItem);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._agcAndColorStripeRestriction !== undefined) {
            hasAnyValues = true;
            internalValueResult.agcAndColorStripeRestriction = this._agcAndColorStripeRestriction;
        }
        if (this._allowPassingVideoContentToUnknownOutput !== undefined) {
            hasAnyValues = true;
            internalValueResult.allowPassingVideoContentToUnknownOutput = this._allowPassingVideoContentToUnknownOutput;
        }
        if (this._analogVideoOpl !== undefined) {
            hasAnyValues = true;
            internalValueResult.analogVideoOpl = this._analogVideoOpl;
        }
        if (this._compressedDigitalAudioOpl !== undefined) {
            hasAnyValues = true;
            internalValueResult.compressedDigitalAudioOpl = this._compressedDigitalAudioOpl;
        }
        if (this._digitalVideoOnlyContentRestriction !== undefined) {
            hasAnyValues = true;
            internalValueResult.digitalVideoOnlyContentRestriction = this._digitalVideoOnlyContentRestriction;
        }
        if (this._firstPlayExpiration !== undefined) {
            hasAnyValues = true;
            internalValueResult.firstPlayExpiration = this._firstPlayExpiration;
        }
        if (this._imageConstraintForAnalogComponentVideoRestriction !== undefined) {
            hasAnyValues = true;
            internalValueResult.imageConstraintForAnalogComponentVideoRestriction = this._imageConstraintForAnalogComponentVideoRestriction;
        }
        if (this._imageConstraintForAnalogComputerMonitorRestriction !== undefined) {
            hasAnyValues = true;
            internalValueResult.imageConstraintForAnalogComputerMonitorRestriction = this._imageConstraintForAnalogComputerMonitorRestriction;
        }
        if (this._scmsRestriction !== undefined) {
            hasAnyValues = true;
            internalValueResult.scmsRestriction = this._scmsRestriction;
        }
        if (this._uncompressedDigitalAudioOpl !== undefined) {
            hasAnyValues = true;
            internalValueResult.uncompressedDigitalAudioOpl = this._uncompressedDigitalAudioOpl;
        }
        if (this._uncompressedDigitalVideoOpl !== undefined) {
            hasAnyValues = true;
            internalValueResult.uncompressedDigitalVideoOpl = this._uncompressedDigitalVideoOpl;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._agcAndColorStripeRestriction = undefined;
            this._allowPassingVideoContentToUnknownOutput = undefined;
            this._analogVideoOpl = undefined;
            this._compressedDigitalAudioOpl = undefined;
            this._digitalVideoOnlyContentRestriction = undefined;
            this._firstPlayExpiration = undefined;
            this._imageConstraintForAnalogComponentVideoRestriction = undefined;
            this._imageConstraintForAnalogComputerMonitorRestriction = undefined;
            this._scmsRestriction = undefined;
            this._uncompressedDigitalAudioOpl = undefined;
            this._uncompressedDigitalVideoOpl = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._agcAndColorStripeRestriction = value.agcAndColorStripeRestriction;
            this._allowPassingVideoContentToUnknownOutput = value.allowPassingVideoContentToUnknownOutput;
            this._analogVideoOpl = value.analogVideoOpl;
            this._compressedDigitalAudioOpl = value.compressedDigitalAudioOpl;
            this._digitalVideoOnlyContentRestriction = value.digitalVideoOnlyContentRestriction;
            this._firstPlayExpiration = value.firstPlayExpiration;
            this._imageConstraintForAnalogComponentVideoRestriction = value.imageConstraintForAnalogComponentVideoRestriction;
            this._imageConstraintForAnalogComputerMonitorRestriction = value.imageConstraintForAnalogComputerMonitorRestriction;
            this._scmsRestriction = value.scmsRestriction;
            this._uncompressedDigitalAudioOpl = value.uncompressedDigitalAudioOpl;
            this._uncompressedDigitalVideoOpl = value.uncompressedDigitalVideoOpl;
        }
    }
    get agcAndColorStripeRestriction() {
        return this.getNumberAttribute('agc_and_color_stripe_restriction');
    }
    set agcAndColorStripeRestriction(value) {
        this._agcAndColorStripeRestriction = value;
    }
    resetAgcAndColorStripeRestriction() {
        this._agcAndColorStripeRestriction = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get agcAndColorStripeRestrictionInput() {
        return this._agcAndColorStripeRestriction;
    }
    get allowPassingVideoContentToUnknownOutput() {
        return this.getStringAttribute('allow_passing_video_content_to_unknown_output');
    }
    set allowPassingVideoContentToUnknownOutput(value) {
        this._allowPassingVideoContentToUnknownOutput = value;
    }
    resetAllowPassingVideoContentToUnknownOutput() {
        this._allowPassingVideoContentToUnknownOutput = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get allowPassingVideoContentToUnknownOutputInput() {
        return this._allowPassingVideoContentToUnknownOutput;
    }
    get analogVideoOpl() {
        return this.getNumberAttribute('analog_video_opl');
    }
    set analogVideoOpl(value) {
        this._analogVideoOpl = value;
    }
    resetAnalogVideoOpl() {
        this._analogVideoOpl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get analogVideoOplInput() {
        return this._analogVideoOpl;
    }
    get compressedDigitalAudioOpl() {
        return this.getNumberAttribute('compressed_digital_audio_opl');
    }
    set compressedDigitalAudioOpl(value) {
        this._compressedDigitalAudioOpl = value;
    }
    resetCompressedDigitalAudioOpl() {
        this._compressedDigitalAudioOpl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get compressedDigitalAudioOplInput() {
        return this._compressedDigitalAudioOpl;
    }
    get digitalVideoOnlyContentRestriction() {
        return this.getBooleanAttribute('digital_video_only_content_restriction');
    }
    set digitalVideoOnlyContentRestriction(value) {
        this._digitalVideoOnlyContentRestriction = value;
    }
    resetDigitalVideoOnlyContentRestriction() {
        this._digitalVideoOnlyContentRestriction = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get digitalVideoOnlyContentRestrictionInput() {
        return this._digitalVideoOnlyContentRestriction;
    }
    get firstPlayExpiration() {
        return this.getStringAttribute('first_play_expiration');
    }
    set firstPlayExpiration(value) {
        this._firstPlayExpiration = value;
    }
    resetFirstPlayExpiration() {
        this._firstPlayExpiration = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get firstPlayExpirationInput() {
        return this._firstPlayExpiration;
    }
    get imageConstraintForAnalogComponentVideoRestriction() {
        return this.getBooleanAttribute('image_constraint_for_analog_component_video_restriction');
    }
    set imageConstraintForAnalogComponentVideoRestriction(value) {
        this._imageConstraintForAnalogComponentVideoRestriction = value;
    }
    resetImageConstraintForAnalogComponentVideoRestriction() {
        this._imageConstraintForAnalogComponentVideoRestriction = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get imageConstraintForAnalogComponentVideoRestrictionInput() {
        return this._imageConstraintForAnalogComponentVideoRestriction;
    }
    get imageConstraintForAnalogComputerMonitorRestriction() {
        return this.getBooleanAttribute('image_constraint_for_analog_computer_monitor_restriction');
    }
    set imageConstraintForAnalogComputerMonitorRestriction(value) {
        this._imageConstraintForAnalogComputerMonitorRestriction = value;
    }
    resetImageConstraintForAnalogComputerMonitorRestriction() {
        this._imageConstraintForAnalogComputerMonitorRestriction = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get imageConstraintForAnalogComputerMonitorRestrictionInput() {
        return this._imageConstraintForAnalogComputerMonitorRestriction;
    }
    get scmsRestriction() {
        return this.getNumberAttribute('scms_restriction');
    }
    set scmsRestriction(value) {
        this._scmsRestriction = value;
    }
    resetScmsRestriction() {
        this._scmsRestriction = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get scmsRestrictionInput() {
        return this._scmsRestriction;
    }
    get uncompressedDigitalAudioOpl() {
        return this.getNumberAttribute('uncompressed_digital_audio_opl');
    }
    set uncompressedDigitalAudioOpl(value) {
        this._uncompressedDigitalAudioOpl = value;
    }
    resetUncompressedDigitalAudioOpl() {
        this._uncompressedDigitalAudioOpl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get uncompressedDigitalAudioOplInput() {
        return this._uncompressedDigitalAudioOpl;
    }
    get uncompressedDigitalVideoOpl() {
        return this.getNumberAttribute('uncompressed_digital_video_opl');
    }
    set uncompressedDigitalVideoOpl(value) {
        this._uncompressedDigitalVideoOpl = value;
    }
    resetUncompressedDigitalVideoOpl() {
        this._uncompressedDigitalVideoOpl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get uncompressedDigitalVideoOplInput() {
        return this._uncompressedDigitalVideoOpl;
    }
}
exports.MediaContentKeyPolicyPolicyOptionPlayreadyConfigurationLicensePlayRightOutputReference = MediaContentKeyPolicyPolicyOptionPlayreadyConfigurationLicensePlayRightOutputReference;
_c = JSII_RTTI_SYMBOL_1;
MediaContentKeyPolicyPolicyOptionPlayreadyConfigurationLicensePlayRightOutputReference[_c] = { fqn: "@cdktf/provider-azurerm.MediaContentKeyPolicyPolicyOptionPlayreadyConfigurationLicensePlayRightOutputReference", version: "0.5.58" };
function mediaContentKeyPolicyPolicyOptionPlayreadyConfigurationLicenseToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        allow_test_devices: cdktf.booleanToTerraform(struct.allowTestDevices),
        begin_date: cdktf.stringToTerraform(struct.beginDate),
        content_key_location_from_header_enabled: cdktf.booleanToTerraform(struct.contentKeyLocationFromHeaderEnabled),
        content_key_location_from_key_id: cdktf.stringToTerraform(struct.contentKeyLocationFromKeyId),
        content_type: cdktf.stringToTerraform(struct.contentType),
        expiration_date: cdktf.stringToTerraform(struct.expirationDate),
        grace_period: cdktf.stringToTerraform(struct.gracePeriod),
        license_type: cdktf.stringToTerraform(struct.licenseType),
        relative_begin_date: cdktf.stringToTerraform(struct.relativeBeginDate),
        relative_expiration_date: cdktf.stringToTerraform(struct.relativeExpirationDate),
        play_right: mediaContentKeyPolicyPolicyOptionPlayreadyConfigurationLicensePlayRightToTerraform(struct.playRight),
    };
}
exports.mediaContentKeyPolicyPolicyOptionPlayreadyConfigurationLicenseToTerraform = mediaContentKeyPolicyPolicyOptionPlayreadyConfigurationLicenseToTerraform;
function mediaContentKeyPolicyPolicyOptionTokenRestrictionRequiredClaimToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        type: cdktf.stringToTerraform(struct.type),
        value: cdktf.stringToTerraform(struct.value),
    };
}
exports.mediaContentKeyPolicyPolicyOptionTokenRestrictionRequiredClaimToTerraform = mediaContentKeyPolicyPolicyOptionTokenRestrictionRequiredClaimToTerraform;
function mediaContentKeyPolicyPolicyOptionTokenRestrictionToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        audience: cdktf.stringToTerraform(struct.audience),
        issuer: cdktf.stringToTerraform(struct.issuer),
        open_id_connect_discovery_document: cdktf.stringToTerraform(struct.openIdConnectDiscoveryDocument),
        primary_rsa_token_key_exponent: cdktf.stringToTerraform(struct.primaryRsaTokenKeyExponent),
        primary_rsa_token_key_modulus: cdktf.stringToTerraform(struct.primaryRsaTokenKeyModulus),
        primary_symmetric_token_key: cdktf.stringToTerraform(struct.primarySymmetricTokenKey),
        primary_x509_token_key_raw: cdktf.stringToTerraform(struct.primaryX509TokenKeyRaw),
        token_type: cdktf.stringToTerraform(struct.tokenType),
        required_claim: cdktf.listMapper(mediaContentKeyPolicyPolicyOptionTokenRestrictionRequiredClaimToTerraform)(struct.requiredClaim),
    };
}
exports.mediaContentKeyPolicyPolicyOptionTokenRestrictionToTerraform = mediaContentKeyPolicyPolicyOptionTokenRestrictionToTerraform;
class MediaContentKeyPolicyPolicyOptionTokenRestrictionOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource, terraformAttribute, isSingleItem) {
        super(terraformResource, terraformAttribute, isSingleItem);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._audience !== undefined) {
            hasAnyValues = true;
            internalValueResult.audience = this._audience;
        }
        if (this._issuer !== undefined) {
            hasAnyValues = true;
            internalValueResult.issuer = this._issuer;
        }
        if (this._openIdConnectDiscoveryDocument !== undefined) {
            hasAnyValues = true;
            internalValueResult.openIdConnectDiscoveryDocument = this._openIdConnectDiscoveryDocument;
        }
        if (this._primaryRsaTokenKeyExponent !== undefined) {
            hasAnyValues = true;
            internalValueResult.primaryRsaTokenKeyExponent = this._primaryRsaTokenKeyExponent;
        }
        if (this._primaryRsaTokenKeyModulus !== undefined) {
            hasAnyValues = true;
            internalValueResult.primaryRsaTokenKeyModulus = this._primaryRsaTokenKeyModulus;
        }
        if (this._primarySymmetricTokenKey !== undefined) {
            hasAnyValues = true;
            internalValueResult.primarySymmetricTokenKey = this._primarySymmetricTokenKey;
        }
        if (this._primaryX509TokenKeyRaw !== undefined) {
            hasAnyValues = true;
            internalValueResult.primaryX509TokenKeyRaw = this._primaryX509TokenKeyRaw;
        }
        if (this._tokenType !== undefined) {
            hasAnyValues = true;
            internalValueResult.tokenType = this._tokenType;
        }
        if (this._requiredClaim !== undefined) {
            hasAnyValues = true;
            internalValueResult.requiredClaim = this._requiredClaim;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._audience = undefined;
            this._issuer = undefined;
            this._openIdConnectDiscoveryDocument = undefined;
            this._primaryRsaTokenKeyExponent = undefined;
            this._primaryRsaTokenKeyModulus = undefined;
            this._primarySymmetricTokenKey = undefined;
            this._primaryX509TokenKeyRaw = undefined;
            this._tokenType = undefined;
            this._requiredClaim = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._audience = value.audience;
            this._issuer = value.issuer;
            this._openIdConnectDiscoveryDocument = value.openIdConnectDiscoveryDocument;
            this._primaryRsaTokenKeyExponent = value.primaryRsaTokenKeyExponent;
            this._primaryRsaTokenKeyModulus = value.primaryRsaTokenKeyModulus;
            this._primarySymmetricTokenKey = value.primarySymmetricTokenKey;
            this._primaryX509TokenKeyRaw = value.primaryX509TokenKeyRaw;
            this._tokenType = value.tokenType;
            this._requiredClaim = value.requiredClaim;
        }
    }
    get audience() {
        return this.getStringAttribute('audience');
    }
    set audience(value) {
        this._audience = value;
    }
    resetAudience() {
        this._audience = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get audienceInput() {
        return this._audience;
    }
    get issuer() {
        return this.getStringAttribute('issuer');
    }
    set issuer(value) {
        this._issuer = value;
    }
    resetIssuer() {
        this._issuer = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get issuerInput() {
        return this._issuer;
    }
    get openIdConnectDiscoveryDocument() {
        return this.getStringAttribute('open_id_connect_discovery_document');
    }
    set openIdConnectDiscoveryDocument(value) {
        this._openIdConnectDiscoveryDocument = value;
    }
    resetOpenIdConnectDiscoveryDocument() {
        this._openIdConnectDiscoveryDocument = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get openIdConnectDiscoveryDocumentInput() {
        return this._openIdConnectDiscoveryDocument;
    }
    get primaryRsaTokenKeyExponent() {
        return this.getStringAttribute('primary_rsa_token_key_exponent');
    }
    set primaryRsaTokenKeyExponent(value) {
        this._primaryRsaTokenKeyExponent = value;
    }
    resetPrimaryRsaTokenKeyExponent() {
        this._primaryRsaTokenKeyExponent = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get primaryRsaTokenKeyExponentInput() {
        return this._primaryRsaTokenKeyExponent;
    }
    get primaryRsaTokenKeyModulus() {
        return this.getStringAttribute('primary_rsa_token_key_modulus');
    }
    set primaryRsaTokenKeyModulus(value) {
        this._primaryRsaTokenKeyModulus = value;
    }
    resetPrimaryRsaTokenKeyModulus() {
        this._primaryRsaTokenKeyModulus = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get primaryRsaTokenKeyModulusInput() {
        return this._primaryRsaTokenKeyModulus;
    }
    get primarySymmetricTokenKey() {
        return this.getStringAttribute('primary_symmetric_token_key');
    }
    set primarySymmetricTokenKey(value) {
        this._primarySymmetricTokenKey = value;
    }
    resetPrimarySymmetricTokenKey() {
        this._primarySymmetricTokenKey = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get primarySymmetricTokenKeyInput() {
        return this._primarySymmetricTokenKey;
    }
    get primaryX509TokenKeyRaw() {
        return this.getStringAttribute('primary_x509_token_key_raw');
    }
    set primaryX509TokenKeyRaw(value) {
        this._primaryX509TokenKeyRaw = value;
    }
    resetPrimaryX509TokenKeyRaw() {
        this._primaryX509TokenKeyRaw = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get primaryX509TokenKeyRawInput() {
        return this._primaryX509TokenKeyRaw;
    }
    get tokenType() {
        return this.getStringAttribute('token_type');
    }
    set tokenType(value) {
        this._tokenType = value;
    }
    resetTokenType() {
        this._tokenType = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tokenTypeInput() {
        return this._tokenType;
    }
    get requiredClaim() {
        // Getting the computed value is not yet implemented
        return this.interpolationForAttribute('required_claim');
    }
    set requiredClaim(value) {
        this._requiredClaim = value;
    }
    resetRequiredClaim() {
        this._requiredClaim = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get requiredClaimInput() {
        return this._requiredClaim;
    }
}
exports.MediaContentKeyPolicyPolicyOptionTokenRestrictionOutputReference = MediaContentKeyPolicyPolicyOptionTokenRestrictionOutputReference;
_d = JSII_RTTI_SYMBOL_1;
MediaContentKeyPolicyPolicyOptionTokenRestrictionOutputReference[_d] = { fqn: "@cdktf/provider-azurerm.MediaContentKeyPolicyPolicyOptionTokenRestrictionOutputReference", version: "0.5.58" };
function mediaContentKeyPolicyPolicyOptionToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        clear_key_configuration_enabled: cdktf.booleanToTerraform(struct.clearKeyConfigurationEnabled),
        name: cdktf.stringToTerraform(struct.name),
        open_restriction_enabled: cdktf.booleanToTerraform(struct.openRestrictionEnabled),
        widevine_configuration_template: cdktf.stringToTerraform(struct.widevineConfigurationTemplate),
        fairplay_configuration: mediaContentKeyPolicyPolicyOptionFairplayConfigurationToTerraform(struct.fairplayConfiguration),
        playready_configuration_license: cdktf.listMapper(mediaContentKeyPolicyPolicyOptionPlayreadyConfigurationLicenseToTerraform)(struct.playreadyConfigurationLicense),
        token_restriction: mediaContentKeyPolicyPolicyOptionTokenRestrictionToTerraform(struct.tokenRestriction),
    };
}
exports.mediaContentKeyPolicyPolicyOptionToTerraform = mediaContentKeyPolicyPolicyOptionToTerraform;
function mediaContentKeyPolicyTimeoutsToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        create: cdktf.stringToTerraform(struct.create),
        delete: cdktf.stringToTerraform(struct.delete),
        read: cdktf.stringToTerraform(struct.read),
        update: cdktf.stringToTerraform(struct.update),
    };
}
exports.mediaContentKeyPolicyTimeoutsToTerraform = mediaContentKeyPolicyTimeoutsToTerraform;
class MediaContentKeyPolicyTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource, terraformAttribute, isSingleItem) {
        super(terraformResource, terraformAttribute, isSingleItem);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._create !== undefined) {
            hasAnyValues = true;
            internalValueResult.create = this._create;
        }
        if (this._delete !== undefined) {
            hasAnyValues = true;
            internalValueResult.delete = this._delete;
        }
        if (this._read !== undefined) {
            hasAnyValues = true;
            internalValueResult.read = this._read;
        }
        if (this._update !== undefined) {
            hasAnyValues = true;
            internalValueResult.update = this._update;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._create = undefined;
            this._delete = undefined;
            this._read = undefined;
            this._update = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._create = value.create;
            this._delete = value.delete;
            this._read = value.read;
            this._update = value.update;
        }
    }
    get create() {
        return this.getStringAttribute('create');
    }
    set create(value) {
        this._create = value;
    }
    resetCreate() {
        this._create = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get createInput() {
        return this._create;
    }
    get delete() {
        return this.getStringAttribute('delete');
    }
    set delete(value) {
        this._delete = value;
    }
    resetDelete() {
        this._delete = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get deleteInput() {
        return this._delete;
    }
    get read() {
        return this.getStringAttribute('read');
    }
    set read(value) {
        this._read = value;
    }
    resetRead() {
        this._read = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get readInput() {
        return this._read;
    }
    get update() {
        return this.getStringAttribute('update');
    }
    set update(value) {
        this._update = value;
    }
    resetUpdate() {
        this._update = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get updateInput() {
        return this._update;
    }
}
exports.MediaContentKeyPolicyTimeoutsOutputReference = MediaContentKeyPolicyTimeoutsOutputReference;
_e = JSII_RTTI_SYMBOL_1;
MediaContentKeyPolicyTimeoutsOutputReference[_e] = { fqn: "@cdktf/provider-azurerm.MediaContentKeyPolicyTimeoutsOutputReference", version: "0.5.58" };
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/media_content_key_policy azurerm_media_content_key_policy}
*/
class MediaContentKeyPolicy extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/media_content_key_policy azurerm_media_content_key_policy} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options MediaContentKeyPolicyConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'azurerm_media_content_key_policy',
            terraformGeneratorMetadata: {
                providerName: 'azurerm'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        // timeouts - computed: false, optional: true, required: false
        this._timeouts = new MediaContentKeyPolicyTimeoutsOutputReference(this, "timeouts", true);
        this._description = config.description;
        this._mediaServicesAccountName = config.mediaServicesAccountName;
        this._name = config.name;
        this._resourceGroupName = config.resourceGroupName;
        this._policyOption = config.policyOption;
        this._timeouts.internalValue = config.timeouts;
    }
    get description() {
        return this.getStringAttribute('description');
    }
    set description(value) {
        this._description = value;
    }
    resetDescription() {
        this._description = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get descriptionInput() {
        return this._description;
    }
    // id - computed: true, optional: true, required: false
    get id() {
        return this.getStringAttribute('id');
    }
    get mediaServicesAccountName() {
        return this.getStringAttribute('media_services_account_name');
    }
    set mediaServicesAccountName(value) {
        this._mediaServicesAccountName = value;
    }
    // Temporarily expose input value. Use with caution.
    get mediaServicesAccountNameInput() {
        return this._mediaServicesAccountName;
    }
    get name() {
        return this.getStringAttribute('name');
    }
    set name(value) {
        this._name = value;
    }
    // Temporarily expose input value. Use with caution.
    get nameInput() {
        return this._name;
    }
    get resourceGroupName() {
        return this.getStringAttribute('resource_group_name');
    }
    set resourceGroupName(value) {
        this._resourceGroupName = value;
    }
    // Temporarily expose input value. Use with caution.
    get resourceGroupNameInput() {
        return this._resourceGroupName;
    }
    get policyOption() {
        // Getting the computed value is not yet implemented
        return cdktf.Token.asAny(cdktf.Fn.tolist(this.interpolationForAttribute('policy_option')));
    }
    set policyOption(value) {
        this._policyOption = value;
    }
    // Temporarily expose input value. Use with caution.
    get policyOptionInput() {
        return this._policyOption;
    }
    get timeouts() {
        return this._timeouts;
    }
    putTimeouts(value) {
        this._timeouts.internalValue = value;
    }
    resetTimeouts() {
        this._timeouts.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get timeoutsInput() {
        return this._timeouts.internalValue;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            description: cdktf.stringToTerraform(this._description),
            media_services_account_name: cdktf.stringToTerraform(this._mediaServicesAccountName),
            name: cdktf.stringToTerraform(this._name),
            resource_group_name: cdktf.stringToTerraform(this._resourceGroupName),
            policy_option: cdktf.listMapper(mediaContentKeyPolicyPolicyOptionToTerraform)(this._policyOption),
            timeouts: mediaContentKeyPolicyTimeoutsToTerraform(this._timeouts.internalValue),
        };
    }
}
exports.MediaContentKeyPolicy = MediaContentKeyPolicy;
_f = JSII_RTTI_SYMBOL_1;
MediaContentKeyPolicy[_f] = { fqn: "@cdktf/provider-azurerm.MediaContentKeyPolicy", version: "0.5.58" };
// =================
// STATIC PROPERTIES
// =================
MediaContentKeyPolicy.tfResourceType = "azurerm_media_content_key_policy";
//# sourceMappingURL=data:application/json;base64,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