import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ResourcePolicyAssignmentConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/resource_policy_assignment#description ResourcePolicyAssignment#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/resource_policy_assignment#display_name ResourcePolicyAssignment#display_name}
    */
    readonly displayName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/resource_policy_assignment#enforce ResourcePolicyAssignment#enforce}
    */
    readonly enforce?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/resource_policy_assignment#location ResourcePolicyAssignment#location}
    */
    readonly location?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/resource_policy_assignment#metadata ResourcePolicyAssignment#metadata}
    */
    readonly metadata?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/resource_policy_assignment#name ResourcePolicyAssignment#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/resource_policy_assignment#not_scopes ResourcePolicyAssignment#not_scopes}
    */
    readonly notScopes?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/resource_policy_assignment#parameters ResourcePolicyAssignment#parameters}
    */
    readonly parameters?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/resource_policy_assignment#policy_definition_id ResourcePolicyAssignment#policy_definition_id}
    */
    readonly policyDefinitionId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/resource_policy_assignment#resource_id ResourcePolicyAssignment#resource_id}
    */
    readonly resourceId: string;
    /**
    * identity block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/resource_policy_assignment#identity ResourcePolicyAssignment#identity}
    */
    readonly identity?: ResourcePolicyAssignmentIdentity;
    /**
    * non_compliance_message block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/resource_policy_assignment#non_compliance_message ResourcePolicyAssignment#non_compliance_message}
    */
    readonly nonComplianceMessage?: ResourcePolicyAssignmentNonComplianceMessage[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/resource_policy_assignment#timeouts ResourcePolicyAssignment#timeouts}
    */
    readonly timeouts?: ResourcePolicyAssignmentTimeouts;
}
export interface ResourcePolicyAssignmentIdentity {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/resource_policy_assignment#type ResourcePolicyAssignment#type}
    */
    readonly type: string;
}
export declare function resourcePolicyAssignmentIdentityToTerraform(struct?: ResourcePolicyAssignmentIdentityOutputReference | ResourcePolicyAssignmentIdentity): any;
export declare class ResourcePolicyAssignmentIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): ResourcePolicyAssignmentIdentity | undefined;
    set internalValue(value: ResourcePolicyAssignmentIdentity | undefined);
    get principalId(): string;
    get tenantId(): string;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface ResourcePolicyAssignmentNonComplianceMessage {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/resource_policy_assignment#content ResourcePolicyAssignment#content}
    */
    readonly content: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/resource_policy_assignment#policy_definition_reference_id ResourcePolicyAssignment#policy_definition_reference_id}
    */
    readonly policyDefinitionReferenceId?: string;
}
export declare function resourcePolicyAssignmentNonComplianceMessageToTerraform(struct?: ResourcePolicyAssignmentNonComplianceMessage | cdktf.IResolvable): any;
export interface ResourcePolicyAssignmentTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/resource_policy_assignment#create ResourcePolicyAssignment#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/resource_policy_assignment#delete ResourcePolicyAssignment#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/resource_policy_assignment#read ResourcePolicyAssignment#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/resource_policy_assignment#update ResourcePolicyAssignment#update}
    */
    readonly update?: string;
}
export declare function resourcePolicyAssignmentTimeoutsToTerraform(struct?: ResourcePolicyAssignmentTimeoutsOutputReference | ResourcePolicyAssignmentTimeouts | cdktf.IResolvable): any;
export declare class ResourcePolicyAssignmentTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): ResourcePolicyAssignmentTimeouts | undefined;
    set internalValue(value: ResourcePolicyAssignmentTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/resource_policy_assignment azurerm_resource_policy_assignment}
*/
export declare class ResourcePolicyAssignment extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/resource_policy_assignment azurerm_resource_policy_assignment} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ResourcePolicyAssignmentConfig
    */
    constructor(scope: Construct, id: string, config: ResourcePolicyAssignmentConfig);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    private _enforce?;
    get enforce(): boolean | cdktf.IResolvable;
    set enforce(value: boolean | cdktf.IResolvable);
    resetEnforce(): void;
    get enforceInput(): boolean | cdktf.IResolvable | undefined;
    get id(): string;
    private _location?;
    get location(): string;
    set location(value: string);
    resetLocation(): void;
    get locationInput(): string | undefined;
    private _metadata?;
    get metadata(): string;
    set metadata(value: string);
    resetMetadata(): void;
    get metadataInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _notScopes?;
    get notScopes(): string[];
    set notScopes(value: string[]);
    resetNotScopes(): void;
    get notScopesInput(): string[] | undefined;
    private _parameters?;
    get parameters(): string;
    set parameters(value: string);
    resetParameters(): void;
    get parametersInput(): string | undefined;
    private _policyDefinitionId?;
    get policyDefinitionId(): string;
    set policyDefinitionId(value: string);
    get policyDefinitionIdInput(): string | undefined;
    private _resourceId?;
    get resourceId(): string;
    set resourceId(value: string);
    get resourceIdInput(): string | undefined;
    private _identity;
    get identity(): ResourcePolicyAssignmentIdentityOutputReference;
    putIdentity(value: ResourcePolicyAssignmentIdentity): void;
    resetIdentity(): void;
    get identityInput(): ResourcePolicyAssignmentIdentity | undefined;
    private _nonComplianceMessage?;
    get nonComplianceMessage(): ResourcePolicyAssignmentNonComplianceMessage[] | cdktf.IResolvable;
    set nonComplianceMessage(value: ResourcePolicyAssignmentNonComplianceMessage[] | cdktf.IResolvable);
    resetNonComplianceMessage(): void;
    get nonComplianceMessageInput(): cdktf.IResolvable | ResourcePolicyAssignmentNonComplianceMessage[] | undefined;
    private _timeouts;
    get timeouts(): ResourcePolicyAssignmentTimeoutsOutputReference;
    putTimeouts(value: ResourcePolicyAssignmentTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): ResourcePolicyAssignmentTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
