import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SentinelAutomationRuleConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_automation_rule#display_name SentinelAutomationRule#display_name}
    */
    readonly displayName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_automation_rule#enabled SentinelAutomationRule#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_automation_rule#expiration SentinelAutomationRule#expiration}
    */
    readonly expiration?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_automation_rule#log_analytics_workspace_id SentinelAutomationRule#log_analytics_workspace_id}
    */
    readonly logAnalyticsWorkspaceId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_automation_rule#name SentinelAutomationRule#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_automation_rule#order SentinelAutomationRule#order}
    */
    readonly order: number;
    /**
    * action_incident block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_automation_rule#action_incident SentinelAutomationRule#action_incident}
    */
    readonly actionIncident?: SentinelAutomationRuleActionIncident[] | cdktf.IResolvable;
    /**
    * action_playbook block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_automation_rule#action_playbook SentinelAutomationRule#action_playbook}
    */
    readonly actionPlaybook?: SentinelAutomationRuleActionPlaybook[] | cdktf.IResolvable;
    /**
    * condition block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_automation_rule#condition SentinelAutomationRule#condition}
    */
    readonly condition?: SentinelAutomationRuleCondition[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_automation_rule#timeouts SentinelAutomationRule#timeouts}
    */
    readonly timeouts?: SentinelAutomationRuleTimeouts;
}
export interface SentinelAutomationRuleActionIncident {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_automation_rule#classification SentinelAutomationRule#classification}
    */
    readonly classification?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_automation_rule#classification_comment SentinelAutomationRule#classification_comment}
    */
    readonly classificationComment?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_automation_rule#labels SentinelAutomationRule#labels}
    */
    readonly labels?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_automation_rule#order SentinelAutomationRule#order}
    */
    readonly order: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_automation_rule#owner_id SentinelAutomationRule#owner_id}
    */
    readonly ownerId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_automation_rule#severity SentinelAutomationRule#severity}
    */
    readonly severity?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_automation_rule#status SentinelAutomationRule#status}
    */
    readonly status?: string;
}
export declare function sentinelAutomationRuleActionIncidentToTerraform(struct?: SentinelAutomationRuleActionIncident | cdktf.IResolvable): any;
export interface SentinelAutomationRuleActionPlaybook {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_automation_rule#logic_app_id SentinelAutomationRule#logic_app_id}
    */
    readonly logicAppId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_automation_rule#order SentinelAutomationRule#order}
    */
    readonly order: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_automation_rule#tenant_id SentinelAutomationRule#tenant_id}
    */
    readonly tenantId?: string;
}
export declare function sentinelAutomationRuleActionPlaybookToTerraform(struct?: SentinelAutomationRuleActionPlaybook | cdktf.IResolvable): any;
export interface SentinelAutomationRuleCondition {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_automation_rule#operator SentinelAutomationRule#operator}
    */
    readonly operator: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_automation_rule#property SentinelAutomationRule#property}
    */
    readonly property: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_automation_rule#values SentinelAutomationRule#values}
    */
    readonly values: string[];
}
export declare function sentinelAutomationRuleConditionToTerraform(struct?: SentinelAutomationRuleCondition | cdktf.IResolvable): any;
export interface SentinelAutomationRuleTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_automation_rule#create SentinelAutomationRule#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_automation_rule#delete SentinelAutomationRule#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_automation_rule#read SentinelAutomationRule#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_automation_rule#update SentinelAutomationRule#update}
    */
    readonly update?: string;
}
export declare function sentinelAutomationRuleTimeoutsToTerraform(struct?: SentinelAutomationRuleTimeoutsOutputReference | SentinelAutomationRuleTimeouts | cdktf.IResolvable): any;
export declare class SentinelAutomationRuleTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): SentinelAutomationRuleTimeouts | undefined;
    set internalValue(value: SentinelAutomationRuleTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_automation_rule azurerm_sentinel_automation_rule}
*/
export declare class SentinelAutomationRule extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_automation_rule azurerm_sentinel_automation_rule} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SentinelAutomationRuleConfig
    */
    constructor(scope: Construct, id: string, config: SentinelAutomationRuleConfig);
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    get displayNameInput(): string | undefined;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _expiration?;
    get expiration(): string;
    set expiration(value: string);
    resetExpiration(): void;
    get expirationInput(): string | undefined;
    get id(): string;
    private _logAnalyticsWorkspaceId?;
    get logAnalyticsWorkspaceId(): string;
    set logAnalyticsWorkspaceId(value: string);
    get logAnalyticsWorkspaceIdInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _order?;
    get order(): number;
    set order(value: number);
    get orderInput(): number | undefined;
    private _actionIncident?;
    get actionIncident(): SentinelAutomationRuleActionIncident[] | cdktf.IResolvable;
    set actionIncident(value: SentinelAutomationRuleActionIncident[] | cdktf.IResolvable);
    resetActionIncident(): void;
    get actionIncidentInput(): cdktf.IResolvable | SentinelAutomationRuleActionIncident[] | undefined;
    private _actionPlaybook?;
    get actionPlaybook(): SentinelAutomationRuleActionPlaybook[] | cdktf.IResolvable;
    set actionPlaybook(value: SentinelAutomationRuleActionPlaybook[] | cdktf.IResolvable);
    resetActionPlaybook(): void;
    get actionPlaybookInput(): cdktf.IResolvable | SentinelAutomationRuleActionPlaybook[] | undefined;
    private _condition?;
    get condition(): SentinelAutomationRuleCondition[] | cdktf.IResolvable;
    set condition(value: SentinelAutomationRuleCondition[] | cdktf.IResolvable);
    resetCondition(): void;
    get conditionInput(): cdktf.IResolvable | SentinelAutomationRuleCondition[] | undefined;
    private _timeouts;
    get timeouts(): SentinelAutomationRuleTimeoutsOutputReference;
    putTimeouts(value: SentinelAutomationRuleTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): SentinelAutomationRuleTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
