import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface StorageObjectReplicationConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_object_replication#destination_storage_account_id StorageObjectReplication#destination_storage_account_id}
    */
    readonly destinationStorageAccountId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_object_replication#source_storage_account_id StorageObjectReplication#source_storage_account_id}
    */
    readonly sourceStorageAccountId: string;
    /**
    * rules block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_object_replication#rules StorageObjectReplication#rules}
    */
    readonly rules: StorageObjectReplicationRules[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_object_replication#timeouts StorageObjectReplication#timeouts}
    */
    readonly timeouts?: StorageObjectReplicationTimeouts;
}
export interface StorageObjectReplicationRules {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_object_replication#copy_blobs_created_after StorageObjectReplication#copy_blobs_created_after}
    */
    readonly copyBlobsCreatedAfter?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_object_replication#destination_container_name StorageObjectReplication#destination_container_name}
    */
    readonly destinationContainerName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_object_replication#filter_out_blobs_with_prefix StorageObjectReplication#filter_out_blobs_with_prefix}
    */
    readonly filterOutBlobsWithPrefix?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_object_replication#source_container_name StorageObjectReplication#source_container_name}
    */
    readonly sourceContainerName: string;
}
export declare function storageObjectReplicationRulesToTerraform(struct?: StorageObjectReplicationRules | cdktf.IResolvable): any;
export interface StorageObjectReplicationTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_object_replication#create StorageObjectReplication#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_object_replication#delete StorageObjectReplication#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_object_replication#read StorageObjectReplication#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_object_replication#update StorageObjectReplication#update}
    */
    readonly update?: string;
}
export declare function storageObjectReplicationTimeoutsToTerraform(struct?: StorageObjectReplicationTimeoutsOutputReference | StorageObjectReplicationTimeouts | cdktf.IResolvable): any;
export declare class StorageObjectReplicationTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): StorageObjectReplicationTimeouts | undefined;
    set internalValue(value: StorageObjectReplicationTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/storage_object_replication azurerm_storage_object_replication}
*/
export declare class StorageObjectReplication extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/storage_object_replication azurerm_storage_object_replication} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options StorageObjectReplicationConfig
    */
    constructor(scope: Construct, id: string, config: StorageObjectReplicationConfig);
    get destinationObjectReplicationId(): string;
    private _destinationStorageAccountId?;
    get destinationStorageAccountId(): string;
    set destinationStorageAccountId(value: string);
    get destinationStorageAccountIdInput(): string | undefined;
    get id(): string;
    get sourceObjectReplicationId(): string;
    private _sourceStorageAccountId?;
    get sourceStorageAccountId(): string;
    set sourceStorageAccountId(value: string);
    get sourceStorageAccountIdInput(): string | undefined;
    private _rules?;
    get rules(): StorageObjectReplicationRules[] | cdktf.IResolvable;
    set rules(value: StorageObjectReplicationRules[] | cdktf.IResolvable);
    get rulesInput(): cdktf.IResolvable | StorageObjectReplicationRules[] | undefined;
    private _timeouts;
    get timeouts(): StorageObjectReplicationTimeoutsOutputReference;
    putTimeouts(value: StorageObjectReplicationTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): StorageObjectReplicationTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
