import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SubscriptionPolicyAssignmentConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/subscription_policy_assignment#description SubscriptionPolicyAssignment#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/subscription_policy_assignment#display_name SubscriptionPolicyAssignment#display_name}
    */
    readonly displayName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/subscription_policy_assignment#enforce SubscriptionPolicyAssignment#enforce}
    */
    readonly enforce?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/subscription_policy_assignment#location SubscriptionPolicyAssignment#location}
    */
    readonly location?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/subscription_policy_assignment#metadata SubscriptionPolicyAssignment#metadata}
    */
    readonly metadata?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/subscription_policy_assignment#name SubscriptionPolicyAssignment#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/subscription_policy_assignment#not_scopes SubscriptionPolicyAssignment#not_scopes}
    */
    readonly notScopes?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/subscription_policy_assignment#parameters SubscriptionPolicyAssignment#parameters}
    */
    readonly parameters?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/subscription_policy_assignment#policy_definition_id SubscriptionPolicyAssignment#policy_definition_id}
    */
    readonly policyDefinitionId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/subscription_policy_assignment#subscription_id SubscriptionPolicyAssignment#subscription_id}
    */
    readonly subscriptionId: string;
    /**
    * identity block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/subscription_policy_assignment#identity SubscriptionPolicyAssignment#identity}
    */
    readonly identity?: SubscriptionPolicyAssignmentIdentity;
    /**
    * non_compliance_message block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/subscription_policy_assignment#non_compliance_message SubscriptionPolicyAssignment#non_compliance_message}
    */
    readonly nonComplianceMessage?: SubscriptionPolicyAssignmentNonComplianceMessage[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/subscription_policy_assignment#timeouts SubscriptionPolicyAssignment#timeouts}
    */
    readonly timeouts?: SubscriptionPolicyAssignmentTimeouts;
}
export interface SubscriptionPolicyAssignmentIdentity {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/subscription_policy_assignment#type SubscriptionPolicyAssignment#type}
    */
    readonly type: string;
}
export declare function subscriptionPolicyAssignmentIdentityToTerraform(struct?: SubscriptionPolicyAssignmentIdentityOutputReference | SubscriptionPolicyAssignmentIdentity): any;
export declare class SubscriptionPolicyAssignmentIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): SubscriptionPolicyAssignmentIdentity | undefined;
    set internalValue(value: SubscriptionPolicyAssignmentIdentity | undefined);
    get principalId(): string;
    get tenantId(): string;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface SubscriptionPolicyAssignmentNonComplianceMessage {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/subscription_policy_assignment#content SubscriptionPolicyAssignment#content}
    */
    readonly content: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/subscription_policy_assignment#policy_definition_reference_id SubscriptionPolicyAssignment#policy_definition_reference_id}
    */
    readonly policyDefinitionReferenceId?: string;
}
export declare function subscriptionPolicyAssignmentNonComplianceMessageToTerraform(struct?: SubscriptionPolicyAssignmentNonComplianceMessage | cdktf.IResolvable): any;
export interface SubscriptionPolicyAssignmentTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/subscription_policy_assignment#create SubscriptionPolicyAssignment#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/subscription_policy_assignment#delete SubscriptionPolicyAssignment#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/subscription_policy_assignment#read SubscriptionPolicyAssignment#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/subscription_policy_assignment#update SubscriptionPolicyAssignment#update}
    */
    readonly update?: string;
}
export declare function subscriptionPolicyAssignmentTimeoutsToTerraform(struct?: SubscriptionPolicyAssignmentTimeoutsOutputReference | SubscriptionPolicyAssignmentTimeouts | cdktf.IResolvable): any;
export declare class SubscriptionPolicyAssignmentTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): SubscriptionPolicyAssignmentTimeouts | undefined;
    set internalValue(value: SubscriptionPolicyAssignmentTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/subscription_policy_assignment azurerm_subscription_policy_assignment}
*/
export declare class SubscriptionPolicyAssignment extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/subscription_policy_assignment azurerm_subscription_policy_assignment} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SubscriptionPolicyAssignmentConfig
    */
    constructor(scope: Construct, id: string, config: SubscriptionPolicyAssignmentConfig);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    private _enforce?;
    get enforce(): boolean | cdktf.IResolvable;
    set enforce(value: boolean | cdktf.IResolvable);
    resetEnforce(): void;
    get enforceInput(): boolean | cdktf.IResolvable | undefined;
    get id(): string;
    private _location?;
    get location(): string;
    set location(value: string);
    resetLocation(): void;
    get locationInput(): string | undefined;
    private _metadata?;
    get metadata(): string;
    set metadata(value: string);
    resetMetadata(): void;
    get metadataInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _notScopes?;
    get notScopes(): string[];
    set notScopes(value: string[]);
    resetNotScopes(): void;
    get notScopesInput(): string[] | undefined;
    private _parameters?;
    get parameters(): string;
    set parameters(value: string);
    resetParameters(): void;
    get parametersInput(): string | undefined;
    private _policyDefinitionId?;
    get policyDefinitionId(): string;
    set policyDefinitionId(value: string);
    get policyDefinitionIdInput(): string | undefined;
    private _subscriptionId?;
    get subscriptionId(): string;
    set subscriptionId(value: string);
    get subscriptionIdInput(): string | undefined;
    private _identity;
    get identity(): SubscriptionPolicyAssignmentIdentityOutputReference;
    putIdentity(value: SubscriptionPolicyAssignmentIdentity): void;
    resetIdentity(): void;
    get identityInput(): SubscriptionPolicyAssignmentIdentity | undefined;
    private _nonComplianceMessage?;
    get nonComplianceMessage(): SubscriptionPolicyAssignmentNonComplianceMessage[] | cdktf.IResolvable;
    set nonComplianceMessage(value: SubscriptionPolicyAssignmentNonComplianceMessage[] | cdktf.IResolvable);
    resetNonComplianceMessage(): void;
    get nonComplianceMessageInput(): cdktf.IResolvable | SubscriptionPolicyAssignmentNonComplianceMessage[] | undefined;
    private _timeouts;
    get timeouts(): SubscriptionPolicyAssignmentTimeoutsOutputReference;
    putTimeouts(value: SubscriptionPolicyAssignmentTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): SubscriptionPolicyAssignmentTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
