import sys

from ingenialink.canopen.network import CanopenNetwork, CAN_DEVICE, CAN_BAUDRATE


def connect_slave():
    net = CanopenNetwork(device=CAN_DEVICE.IXXAT,
                         channel=0,
                         baudrate=CAN_BAUDRATE.Baudrate_1M)

    servo = net.connect_to_slave(
        target=32,
        dictionary='../../resources/dictionaries/eve-net-c_can_1.8.1.xdf',
        eds='../../resources/dictionaries/eve-net-c_1.8.1.eds')
    
    return servo, net


def load_config_example():
    """Loads a given configuration file into the drive."""
    servo, net = connect_slave()
    servo.load_configuration(
        'can_config.xcf')
    servo.load_configuration(
        'can_config_0.xcf',
        subnode=0)
    servo.load_configuration(
        'can_config_1.xcf',
        subnode=1)

    net.disconnect_from_slave(servo)


def save_config_example():
    """Saves the drive configuration into a file."""

    servo, net = connect_slave()
    servo.save_configuration(
        'can_config.xcf')
    servo.save_configuration(
        'can_config_0.xcf',
        subnode=0)
    servo.save_configuration(
        'can_config_1.xcf',
        subnode=1)

    net.disconnect_from_slave(servo)


if __name__ == '__main__':
    save_config_example()
    load_config_example()
    sys.exit()
