# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SwitchRoutingOspfArgs', 'SwitchRoutingOspf']

@pulumi.input_type
class SwitchRoutingOspfArgs:
    def __init__(__self__, *,
                 network_id: pulumi.Input[builtins.str],
                 areas: Optional[pulumi.Input[Sequence[pulumi.Input['SwitchRoutingOspfAreaArgs']]]] = None,
                 dead_timer_in_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 hello_timer_in_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 md5_authentication_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 md5_authentication_key: Optional[pulumi.Input['SwitchRoutingOspfMd5AuthenticationKeyArgs']] = None,
                 v3: Optional[pulumi.Input['SwitchRoutingOspfV3Args']] = None):
        """
        The set of arguments for constructing a SwitchRoutingOspf resource.
        :param pulumi.Input[builtins.str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[Sequence[pulumi.Input['SwitchRoutingOspfAreaArgs']]] areas: OSPF areas
        :param pulumi.Input[builtins.int] dead_timer_in_seconds: Time interval to determine when the peer will be declared inactive/dead. Value must be between 1 and 65535
        :param pulumi.Input[builtins.bool] enabled: Boolean value to enable or disable OSPF routing. OSPF routing is disabled by default.
        :param pulumi.Input[builtins.int] hello_timer_in_seconds: Time interval in seconds at which hello packet will be sent to OSPF neighbors to maintain connectivity. Value must be between 1 and 255. Default is 10 seconds.
        :param pulumi.Input[builtins.bool] md5_authentication_enabled: Boolean value to enable or disable MD5 authentication. MD5 authentication is disabled by default.
        :param pulumi.Input['SwitchRoutingOspfMd5AuthenticationKeyArgs'] md5_authentication_key: MD5 authentication credentials. This param is only relevant if md5AuthenticationEnabled is true
        :param pulumi.Input['SwitchRoutingOspfV3Args'] v3: OSPF v3 configuration
        """
        pulumi.set(__self__, "network_id", network_id)
        if areas is not None:
            pulumi.set(__self__, "areas", areas)
        if dead_timer_in_seconds is not None:
            pulumi.set(__self__, "dead_timer_in_seconds", dead_timer_in_seconds)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if hello_timer_in_seconds is not None:
            pulumi.set(__self__, "hello_timer_in_seconds", hello_timer_in_seconds)
        if md5_authentication_enabled is not None:
            pulumi.set(__self__, "md5_authentication_enabled", md5_authentication_enabled)
        if md5_authentication_key is not None:
            pulumi.set(__self__, "md5_authentication_key", md5_authentication_key)
        if v3 is not None:
            pulumi.set(__self__, "v3", v3)

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Input[builtins.str]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "network_id", value)

    @property
    @pulumi.getter
    def areas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SwitchRoutingOspfAreaArgs']]]]:
        """
        OSPF areas
        """
        return pulumi.get(self, "areas")

    @areas.setter
    def areas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SwitchRoutingOspfAreaArgs']]]]):
        pulumi.set(self, "areas", value)

    @property
    @pulumi.getter(name="deadTimerInSeconds")
    def dead_timer_in_seconds(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Time interval to determine when the peer will be declared inactive/dead. Value must be between 1 and 65535
        """
        return pulumi.get(self, "dead_timer_in_seconds")

    @dead_timer_in_seconds.setter
    def dead_timer_in_seconds(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "dead_timer_in_seconds", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Boolean value to enable or disable OSPF routing. OSPF routing is disabled by default.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="helloTimerInSeconds")
    def hello_timer_in_seconds(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Time interval in seconds at which hello packet will be sent to OSPF neighbors to maintain connectivity. Value must be between 1 and 255. Default is 10 seconds.
        """
        return pulumi.get(self, "hello_timer_in_seconds")

    @hello_timer_in_seconds.setter
    def hello_timer_in_seconds(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "hello_timer_in_seconds", value)

    @property
    @pulumi.getter(name="md5AuthenticationEnabled")
    def md5_authentication_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Boolean value to enable or disable MD5 authentication. MD5 authentication is disabled by default.
        """
        return pulumi.get(self, "md5_authentication_enabled")

    @md5_authentication_enabled.setter
    def md5_authentication_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "md5_authentication_enabled", value)

    @property
    @pulumi.getter(name="md5AuthenticationKey")
    def md5_authentication_key(self) -> Optional[pulumi.Input['SwitchRoutingOspfMd5AuthenticationKeyArgs']]:
        """
        MD5 authentication credentials. This param is only relevant if md5AuthenticationEnabled is true
        """
        return pulumi.get(self, "md5_authentication_key")

    @md5_authentication_key.setter
    def md5_authentication_key(self, value: Optional[pulumi.Input['SwitchRoutingOspfMd5AuthenticationKeyArgs']]):
        pulumi.set(self, "md5_authentication_key", value)

    @property
    @pulumi.getter
    def v3(self) -> Optional[pulumi.Input['SwitchRoutingOspfV3Args']]:
        """
        OSPF v3 configuration
        """
        return pulumi.get(self, "v3")

    @v3.setter
    def v3(self, value: Optional[pulumi.Input['SwitchRoutingOspfV3Args']]):
        pulumi.set(self, "v3", value)


@pulumi.input_type
class _SwitchRoutingOspfState:
    def __init__(__self__, *,
                 areas: Optional[pulumi.Input[Sequence[pulumi.Input['SwitchRoutingOspfAreaArgs']]]] = None,
                 dead_timer_in_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 hello_timer_in_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 md5_authentication_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 md5_authentication_key: Optional[pulumi.Input['SwitchRoutingOspfMd5AuthenticationKeyArgs']] = None,
                 network_id: Optional[pulumi.Input[builtins.str]] = None,
                 v3: Optional[pulumi.Input['SwitchRoutingOspfV3Args']] = None):
        """
        Input properties used for looking up and filtering SwitchRoutingOspf resources.
        :param pulumi.Input[Sequence[pulumi.Input['SwitchRoutingOspfAreaArgs']]] areas: OSPF areas
        :param pulumi.Input[builtins.int] dead_timer_in_seconds: Time interval to determine when the peer will be declared inactive/dead. Value must be between 1 and 65535
        :param pulumi.Input[builtins.bool] enabled: Boolean value to enable or disable OSPF routing. OSPF routing is disabled by default.
        :param pulumi.Input[builtins.int] hello_timer_in_seconds: Time interval in seconds at which hello packet will be sent to OSPF neighbors to maintain connectivity. Value must be between 1 and 255. Default is 10 seconds.
        :param pulumi.Input[builtins.bool] md5_authentication_enabled: Boolean value to enable or disable MD5 authentication. MD5 authentication is disabled by default.
        :param pulumi.Input['SwitchRoutingOspfMd5AuthenticationKeyArgs'] md5_authentication_key: MD5 authentication credentials. This param is only relevant if md5AuthenticationEnabled is true
        :param pulumi.Input[builtins.str] network_id: networkId path parameter. Network ID
        :param pulumi.Input['SwitchRoutingOspfV3Args'] v3: OSPF v3 configuration
        """
        if areas is not None:
            pulumi.set(__self__, "areas", areas)
        if dead_timer_in_seconds is not None:
            pulumi.set(__self__, "dead_timer_in_seconds", dead_timer_in_seconds)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if hello_timer_in_seconds is not None:
            pulumi.set(__self__, "hello_timer_in_seconds", hello_timer_in_seconds)
        if md5_authentication_enabled is not None:
            pulumi.set(__self__, "md5_authentication_enabled", md5_authentication_enabled)
        if md5_authentication_key is not None:
            pulumi.set(__self__, "md5_authentication_key", md5_authentication_key)
        if network_id is not None:
            pulumi.set(__self__, "network_id", network_id)
        if v3 is not None:
            pulumi.set(__self__, "v3", v3)

    @property
    @pulumi.getter
    def areas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SwitchRoutingOspfAreaArgs']]]]:
        """
        OSPF areas
        """
        return pulumi.get(self, "areas")

    @areas.setter
    def areas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SwitchRoutingOspfAreaArgs']]]]):
        pulumi.set(self, "areas", value)

    @property
    @pulumi.getter(name="deadTimerInSeconds")
    def dead_timer_in_seconds(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Time interval to determine when the peer will be declared inactive/dead. Value must be between 1 and 65535
        """
        return pulumi.get(self, "dead_timer_in_seconds")

    @dead_timer_in_seconds.setter
    def dead_timer_in_seconds(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "dead_timer_in_seconds", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Boolean value to enable or disable OSPF routing. OSPF routing is disabled by default.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="helloTimerInSeconds")
    def hello_timer_in_seconds(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Time interval in seconds at which hello packet will be sent to OSPF neighbors to maintain connectivity. Value must be between 1 and 255. Default is 10 seconds.
        """
        return pulumi.get(self, "hello_timer_in_seconds")

    @hello_timer_in_seconds.setter
    def hello_timer_in_seconds(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "hello_timer_in_seconds", value)

    @property
    @pulumi.getter(name="md5AuthenticationEnabled")
    def md5_authentication_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Boolean value to enable or disable MD5 authentication. MD5 authentication is disabled by default.
        """
        return pulumi.get(self, "md5_authentication_enabled")

    @md5_authentication_enabled.setter
    def md5_authentication_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "md5_authentication_enabled", value)

    @property
    @pulumi.getter(name="md5AuthenticationKey")
    def md5_authentication_key(self) -> Optional[pulumi.Input['SwitchRoutingOspfMd5AuthenticationKeyArgs']]:
        """
        MD5 authentication credentials. This param is only relevant if md5AuthenticationEnabled is true
        """
        return pulumi.get(self, "md5_authentication_key")

    @md5_authentication_key.setter
    def md5_authentication_key(self, value: Optional[pulumi.Input['SwitchRoutingOspfMd5AuthenticationKeyArgs']]):
        pulumi.set(self, "md5_authentication_key", value)

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "network_id", value)

    @property
    @pulumi.getter
    def v3(self) -> Optional[pulumi.Input['SwitchRoutingOspfV3Args']]:
        """
        OSPF v3 configuration
        """
        return pulumi.get(self, "v3")

    @v3.setter
    def v3(self, value: Optional[pulumi.Input['SwitchRoutingOspfV3Args']]):
        pulumi.set(self, "v3", value)


class SwitchRoutingOspf(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 areas: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SwitchRoutingOspfAreaArgs', 'SwitchRoutingOspfAreaArgsDict']]]]] = None,
                 dead_timer_in_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 hello_timer_in_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 md5_authentication_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 md5_authentication_key: Optional[pulumi.Input[Union['SwitchRoutingOspfMd5AuthenticationKeyArgs', 'SwitchRoutingOspfMd5AuthenticationKeyArgsDict']]] = None,
                 network_id: Optional[pulumi.Input[builtins.str]] = None,
                 v3: Optional[pulumi.Input[Union['SwitchRoutingOspfV3Args', 'SwitchRoutingOspfV3ArgsDict']]] = None,
                 __props__=None):
        """
        ## Example Usage

        ## Import

        ```sh
        $ pulumi import meraki:networks/switchRoutingOspf:SwitchRoutingOspf example "network_id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SwitchRoutingOspfAreaArgs', 'SwitchRoutingOspfAreaArgsDict']]]] areas: OSPF areas
        :param pulumi.Input[builtins.int] dead_timer_in_seconds: Time interval to determine when the peer will be declared inactive/dead. Value must be between 1 and 65535
        :param pulumi.Input[builtins.bool] enabled: Boolean value to enable or disable OSPF routing. OSPF routing is disabled by default.
        :param pulumi.Input[builtins.int] hello_timer_in_seconds: Time interval in seconds at which hello packet will be sent to OSPF neighbors to maintain connectivity. Value must be between 1 and 255. Default is 10 seconds.
        :param pulumi.Input[builtins.bool] md5_authentication_enabled: Boolean value to enable or disable MD5 authentication. MD5 authentication is disabled by default.
        :param pulumi.Input[Union['SwitchRoutingOspfMd5AuthenticationKeyArgs', 'SwitchRoutingOspfMd5AuthenticationKeyArgsDict']] md5_authentication_key: MD5 authentication credentials. This param is only relevant if md5AuthenticationEnabled is true
        :param pulumi.Input[builtins.str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[Union['SwitchRoutingOspfV3Args', 'SwitchRoutingOspfV3ArgsDict']] v3: OSPF v3 configuration
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SwitchRoutingOspfArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ## Import

        ```sh
        $ pulumi import meraki:networks/switchRoutingOspf:SwitchRoutingOspf example "network_id"
        ```

        :param str resource_name: The name of the resource.
        :param SwitchRoutingOspfArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SwitchRoutingOspfArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 areas: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SwitchRoutingOspfAreaArgs', 'SwitchRoutingOspfAreaArgsDict']]]]] = None,
                 dead_timer_in_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 hello_timer_in_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 md5_authentication_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 md5_authentication_key: Optional[pulumi.Input[Union['SwitchRoutingOspfMd5AuthenticationKeyArgs', 'SwitchRoutingOspfMd5AuthenticationKeyArgsDict']]] = None,
                 network_id: Optional[pulumi.Input[builtins.str]] = None,
                 v3: Optional[pulumi.Input[Union['SwitchRoutingOspfV3Args', 'SwitchRoutingOspfV3ArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SwitchRoutingOspfArgs.__new__(SwitchRoutingOspfArgs)

            __props__.__dict__["areas"] = areas
            __props__.__dict__["dead_timer_in_seconds"] = dead_timer_in_seconds
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["hello_timer_in_seconds"] = hello_timer_in_seconds
            __props__.__dict__["md5_authentication_enabled"] = md5_authentication_enabled
            __props__.__dict__["md5_authentication_key"] = md5_authentication_key
            if network_id is None and not opts.urn:
                raise TypeError("Missing required property 'network_id'")
            __props__.__dict__["network_id"] = network_id
            __props__.__dict__["v3"] = v3
        super(SwitchRoutingOspf, __self__).__init__(
            'meraki:networks/switchRoutingOspf:SwitchRoutingOspf',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            areas: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SwitchRoutingOspfAreaArgs', 'SwitchRoutingOspfAreaArgsDict']]]]] = None,
            dead_timer_in_seconds: Optional[pulumi.Input[builtins.int]] = None,
            enabled: Optional[pulumi.Input[builtins.bool]] = None,
            hello_timer_in_seconds: Optional[pulumi.Input[builtins.int]] = None,
            md5_authentication_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            md5_authentication_key: Optional[pulumi.Input[Union['SwitchRoutingOspfMd5AuthenticationKeyArgs', 'SwitchRoutingOspfMd5AuthenticationKeyArgsDict']]] = None,
            network_id: Optional[pulumi.Input[builtins.str]] = None,
            v3: Optional[pulumi.Input[Union['SwitchRoutingOspfV3Args', 'SwitchRoutingOspfV3ArgsDict']]] = None) -> 'SwitchRoutingOspf':
        """
        Get an existing SwitchRoutingOspf resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SwitchRoutingOspfAreaArgs', 'SwitchRoutingOspfAreaArgsDict']]]] areas: OSPF areas
        :param pulumi.Input[builtins.int] dead_timer_in_seconds: Time interval to determine when the peer will be declared inactive/dead. Value must be between 1 and 65535
        :param pulumi.Input[builtins.bool] enabled: Boolean value to enable or disable OSPF routing. OSPF routing is disabled by default.
        :param pulumi.Input[builtins.int] hello_timer_in_seconds: Time interval in seconds at which hello packet will be sent to OSPF neighbors to maintain connectivity. Value must be between 1 and 255. Default is 10 seconds.
        :param pulumi.Input[builtins.bool] md5_authentication_enabled: Boolean value to enable or disable MD5 authentication. MD5 authentication is disabled by default.
        :param pulumi.Input[Union['SwitchRoutingOspfMd5AuthenticationKeyArgs', 'SwitchRoutingOspfMd5AuthenticationKeyArgsDict']] md5_authentication_key: MD5 authentication credentials. This param is only relevant if md5AuthenticationEnabled is true
        :param pulumi.Input[builtins.str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[Union['SwitchRoutingOspfV3Args', 'SwitchRoutingOspfV3ArgsDict']] v3: OSPF v3 configuration
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SwitchRoutingOspfState.__new__(_SwitchRoutingOspfState)

        __props__.__dict__["areas"] = areas
        __props__.__dict__["dead_timer_in_seconds"] = dead_timer_in_seconds
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["hello_timer_in_seconds"] = hello_timer_in_seconds
        __props__.__dict__["md5_authentication_enabled"] = md5_authentication_enabled
        __props__.__dict__["md5_authentication_key"] = md5_authentication_key
        __props__.__dict__["network_id"] = network_id
        __props__.__dict__["v3"] = v3
        return SwitchRoutingOspf(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def areas(self) -> pulumi.Output[Sequence['outputs.SwitchRoutingOspfArea']]:
        """
        OSPF areas
        """
        return pulumi.get(self, "areas")

    @property
    @pulumi.getter(name="deadTimerInSeconds")
    def dead_timer_in_seconds(self) -> pulumi.Output[builtins.int]:
        """
        Time interval to determine when the peer will be declared inactive/dead. Value must be between 1 and 65535
        """
        return pulumi.get(self, "dead_timer_in_seconds")

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[builtins.bool]:
        """
        Boolean value to enable or disable OSPF routing. OSPF routing is disabled by default.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="helloTimerInSeconds")
    def hello_timer_in_seconds(self) -> pulumi.Output[builtins.int]:
        """
        Time interval in seconds at which hello packet will be sent to OSPF neighbors to maintain connectivity. Value must be between 1 and 255. Default is 10 seconds.
        """
        return pulumi.get(self, "hello_timer_in_seconds")

    @property
    @pulumi.getter(name="md5AuthenticationEnabled")
    def md5_authentication_enabled(self) -> pulumi.Output[builtins.bool]:
        """
        Boolean value to enable or disable MD5 authentication. MD5 authentication is disabled by default.
        """
        return pulumi.get(self, "md5_authentication_enabled")

    @property
    @pulumi.getter(name="md5AuthenticationKey")
    def md5_authentication_key(self) -> pulumi.Output['outputs.SwitchRoutingOspfMd5AuthenticationKey']:
        """
        MD5 authentication credentials. This param is only relevant if md5AuthenticationEnabled is true
        """
        return pulumi.get(self, "md5_authentication_key")

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Output[builtins.str]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @property
    @pulumi.getter
    def v3(self) -> pulumi.Output['outputs.SwitchRoutingOspfV3']:
        """
        OSPF v3 configuration
        """
        return pulumi.get(self, "v3")

