# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['SamlIdpsArgs', 'SamlIdps']

@pulumi.input_type
class SamlIdpsArgs:
    def __init__(__self__, *,
                 organization_id: pulumi.Input[builtins.str],
                 idp_id: Optional[pulumi.Input[builtins.str]] = None,
                 slo_logout_url: Optional[pulumi.Input[builtins.str]] = None,
                 x509cert_sha1_fingerprint: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a SamlIdps resource.
        :param pulumi.Input[builtins.str] organization_id: organizationId path parameter. Organization ID
        :param pulumi.Input[builtins.str] idp_id: ID associated with the SAML Identity Provider (IdP)
        :param pulumi.Input[builtins.str] slo_logout_url: Dashboard will redirect users to this URL when they sign out.
        :param pulumi.Input[builtins.str] x509cert_sha1_fingerprint: Fingerprint (SHA1) of the SAML certificate provided by your Identity Provider (IdP). This will be used for encryption / validation.
        """
        pulumi.set(__self__, "organization_id", organization_id)
        if idp_id is not None:
            pulumi.set(__self__, "idp_id", idp_id)
        if slo_logout_url is not None:
            pulumi.set(__self__, "slo_logout_url", slo_logout_url)
        if x509cert_sha1_fingerprint is not None:
            pulumi.set(__self__, "x509cert_sha1_fingerprint", x509cert_sha1_fingerprint)

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> pulumi.Input[builtins.str]:
        """
        organizationId path parameter. Organization ID
        """
        return pulumi.get(self, "organization_id")

    @organization_id.setter
    def organization_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "organization_id", value)

    @property
    @pulumi.getter(name="idpId")
    def idp_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ID associated with the SAML Identity Provider (IdP)
        """
        return pulumi.get(self, "idp_id")

    @idp_id.setter
    def idp_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "idp_id", value)

    @property
    @pulumi.getter(name="sloLogoutUrl")
    def slo_logout_url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Dashboard will redirect users to this URL when they sign out.
        """
        return pulumi.get(self, "slo_logout_url")

    @slo_logout_url.setter
    def slo_logout_url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "slo_logout_url", value)

    @property
    @pulumi.getter(name="x509certSha1Fingerprint")
    def x509cert_sha1_fingerprint(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Fingerprint (SHA1) of the SAML certificate provided by your Identity Provider (IdP). This will be used for encryption / validation.
        """
        return pulumi.get(self, "x509cert_sha1_fingerprint")

    @x509cert_sha1_fingerprint.setter
    def x509cert_sha1_fingerprint(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "x509cert_sha1_fingerprint", value)


@pulumi.input_type
class _SamlIdpsState:
    def __init__(__self__, *,
                 consumer_url: Optional[pulumi.Input[builtins.str]] = None,
                 idp_id: Optional[pulumi.Input[builtins.str]] = None,
                 organization_id: Optional[pulumi.Input[builtins.str]] = None,
                 slo_logout_url: Optional[pulumi.Input[builtins.str]] = None,
                 x509cert_sha1_fingerprint: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering SamlIdps resources.
        :param pulumi.Input[builtins.str] consumer_url: URL that is consuming SAML Identity Provider (IdP)
        :param pulumi.Input[builtins.str] idp_id: ID associated with the SAML Identity Provider (IdP)
        :param pulumi.Input[builtins.str] organization_id: organizationId path parameter. Organization ID
        :param pulumi.Input[builtins.str] slo_logout_url: Dashboard will redirect users to this URL when they sign out.
        :param pulumi.Input[builtins.str] x509cert_sha1_fingerprint: Fingerprint (SHA1) of the SAML certificate provided by your Identity Provider (IdP). This will be used for encryption / validation.
        """
        if consumer_url is not None:
            pulumi.set(__self__, "consumer_url", consumer_url)
        if idp_id is not None:
            pulumi.set(__self__, "idp_id", idp_id)
        if organization_id is not None:
            pulumi.set(__self__, "organization_id", organization_id)
        if slo_logout_url is not None:
            pulumi.set(__self__, "slo_logout_url", slo_logout_url)
        if x509cert_sha1_fingerprint is not None:
            pulumi.set(__self__, "x509cert_sha1_fingerprint", x509cert_sha1_fingerprint)

    @property
    @pulumi.getter(name="consumerUrl")
    def consumer_url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        URL that is consuming SAML Identity Provider (IdP)
        """
        return pulumi.get(self, "consumer_url")

    @consumer_url.setter
    def consumer_url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "consumer_url", value)

    @property
    @pulumi.getter(name="idpId")
    def idp_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ID associated with the SAML Identity Provider (IdP)
        """
        return pulumi.get(self, "idp_id")

    @idp_id.setter
    def idp_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "idp_id", value)

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        organizationId path parameter. Organization ID
        """
        return pulumi.get(self, "organization_id")

    @organization_id.setter
    def organization_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "organization_id", value)

    @property
    @pulumi.getter(name="sloLogoutUrl")
    def slo_logout_url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Dashboard will redirect users to this URL when they sign out.
        """
        return pulumi.get(self, "slo_logout_url")

    @slo_logout_url.setter
    def slo_logout_url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "slo_logout_url", value)

    @property
    @pulumi.getter(name="x509certSha1Fingerprint")
    def x509cert_sha1_fingerprint(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Fingerprint (SHA1) of the SAML certificate provided by your Identity Provider (IdP). This will be used for encryption / validation.
        """
        return pulumi.get(self, "x509cert_sha1_fingerprint")

    @x509cert_sha1_fingerprint.setter
    def x509cert_sha1_fingerprint(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "x509cert_sha1_fingerprint", value)


class SamlIdps(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 idp_id: Optional[pulumi.Input[builtins.str]] = None,
                 organization_id: Optional[pulumi.Input[builtins.str]] = None,
                 slo_logout_url: Optional[pulumi.Input[builtins.str]] = None,
                 x509cert_sha1_fingerprint: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_meraki as meraki

        example = meraki.organizations.SamlIdps("example",
            organization_id="string",
            slo_logout_url="https://somewhere.com",
            x509cert_sha1_fingerprint="00:11:22:33:44:55:66:77:88:99:00:11:22:33:44:55:66:77:88:99")
        pulumi.export("merakiOrganizationsSamlIdpsExample", example)
        ```

        ## Import

        ```sh
        $ pulumi import meraki:organizations/samlIdps:SamlIdps example "idp_id,organization_id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] idp_id: ID associated with the SAML Identity Provider (IdP)
        :param pulumi.Input[builtins.str] organization_id: organizationId path parameter. Organization ID
        :param pulumi.Input[builtins.str] slo_logout_url: Dashboard will redirect users to this URL when they sign out.
        :param pulumi.Input[builtins.str] x509cert_sha1_fingerprint: Fingerprint (SHA1) of the SAML certificate provided by your Identity Provider (IdP). This will be used for encryption / validation.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SamlIdpsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_meraki as meraki

        example = meraki.organizations.SamlIdps("example",
            organization_id="string",
            slo_logout_url="https://somewhere.com",
            x509cert_sha1_fingerprint="00:11:22:33:44:55:66:77:88:99:00:11:22:33:44:55:66:77:88:99")
        pulumi.export("merakiOrganizationsSamlIdpsExample", example)
        ```

        ## Import

        ```sh
        $ pulumi import meraki:organizations/samlIdps:SamlIdps example "idp_id,organization_id"
        ```

        :param str resource_name: The name of the resource.
        :param SamlIdpsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SamlIdpsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 idp_id: Optional[pulumi.Input[builtins.str]] = None,
                 organization_id: Optional[pulumi.Input[builtins.str]] = None,
                 slo_logout_url: Optional[pulumi.Input[builtins.str]] = None,
                 x509cert_sha1_fingerprint: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SamlIdpsArgs.__new__(SamlIdpsArgs)

            __props__.__dict__["idp_id"] = idp_id
            if organization_id is None and not opts.urn:
                raise TypeError("Missing required property 'organization_id'")
            __props__.__dict__["organization_id"] = organization_id
            __props__.__dict__["slo_logout_url"] = slo_logout_url
            __props__.__dict__["x509cert_sha1_fingerprint"] = x509cert_sha1_fingerprint
            __props__.__dict__["consumer_url"] = None
        super(SamlIdps, __self__).__init__(
            'meraki:organizations/samlIdps:SamlIdps',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            consumer_url: Optional[pulumi.Input[builtins.str]] = None,
            idp_id: Optional[pulumi.Input[builtins.str]] = None,
            organization_id: Optional[pulumi.Input[builtins.str]] = None,
            slo_logout_url: Optional[pulumi.Input[builtins.str]] = None,
            x509cert_sha1_fingerprint: Optional[pulumi.Input[builtins.str]] = None) -> 'SamlIdps':
        """
        Get an existing SamlIdps resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] consumer_url: URL that is consuming SAML Identity Provider (IdP)
        :param pulumi.Input[builtins.str] idp_id: ID associated with the SAML Identity Provider (IdP)
        :param pulumi.Input[builtins.str] organization_id: organizationId path parameter. Organization ID
        :param pulumi.Input[builtins.str] slo_logout_url: Dashboard will redirect users to this URL when they sign out.
        :param pulumi.Input[builtins.str] x509cert_sha1_fingerprint: Fingerprint (SHA1) of the SAML certificate provided by your Identity Provider (IdP). This will be used for encryption / validation.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SamlIdpsState.__new__(_SamlIdpsState)

        __props__.__dict__["consumer_url"] = consumer_url
        __props__.__dict__["idp_id"] = idp_id
        __props__.__dict__["organization_id"] = organization_id
        __props__.__dict__["slo_logout_url"] = slo_logout_url
        __props__.__dict__["x509cert_sha1_fingerprint"] = x509cert_sha1_fingerprint
        return SamlIdps(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="consumerUrl")
    def consumer_url(self) -> pulumi.Output[builtins.str]:
        """
        URL that is consuming SAML Identity Provider (IdP)
        """
        return pulumi.get(self, "consumer_url")

    @property
    @pulumi.getter(name="idpId")
    def idp_id(self) -> pulumi.Output[builtins.str]:
        """
        ID associated with the SAML Identity Provider (IdP)
        """
        return pulumi.get(self, "idp_id")

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> pulumi.Output[builtins.str]:
        """
        organizationId path parameter. Organization ID
        """
        return pulumi.get(self, "organization_id")

    @property
    @pulumi.getter(name="sloLogoutUrl")
    def slo_logout_url(self) -> pulumi.Output[builtins.str]:
        """
        Dashboard will redirect users to this URL when they sign out.
        """
        return pulumi.get(self, "slo_logout_url")

    @property
    @pulumi.getter(name="x509certSha1Fingerprint")
    def x509cert_sha1_fingerprint(self) -> pulumi.Output[builtins.str]:
        """
        Fingerprint (SHA1) of the SAML certificate provided by your Identity Provider (IdP). This will be used for encryption / validation.
        """
        return pulumi.get(self, "x509cert_sha1_fingerprint")

