"""
A port of the LibXC internal flags to Python. Header defines must be physically copied.
"""

XC_UNPOLARIZED = 1
XC_POLARIZED = 2

XC_NON_RELATIVISTIC = 0
XC_RELATIVISTIC = 1

XC_EXCHANGE = 0
XC_CORRELATION = 1
XC_EXCHANGE_CORRELATION = 2
XC_KINETIC = 3

XC_FAMILY_UNKNOWN = -1
XC_FAMILY_LDA = 1
XC_FAMILY_GGA = 2
XC_FAMILY_MGGA = 4
XC_FAMILY_LCA = 8
XC_FAMILY_OEP = 16

XC_FLAGS_HAVE_EXC = (1 << 0)  # = 1
XC_FLAGS_HAVE_VXC = (1 << 1)  # = 2
XC_FLAGS_HAVE_FXC = (1 << 2)  # = 4
XC_FLAGS_HAVE_KXC = (1 << 3)  # = 8
XC_FLAGS_HAVE_LXC = (1 << 4)  # = 16
XC_FLAGS_HAVE_ALL = 31 # The most common case
XC_FLAGS_1D = (1 << 5)  # = 32
XC_FLAGS_2D = (1 << 6)  # = 64
XC_FLAGS_3D = (1 << 7)  # = 128
XC_FLAGS_VV10 = (1 << 10)  #  1024
XC_FLAGS_STABLE = (1 << 13)  #  8192
XC_FLAGS_DEVELOPMENT = (1 << 14)  # 16384
XC_FLAGS_NEEDS_LAPLACIAN = (1 << 15)  # 32768

# possible terms in a hybrid functional
XC_HYB_NONE = 0
XC_HYB_FOCK = 1
XC_HYB_PT2 = 2
XC_HYB_ERF_SR = 4
XC_HYB_YUKAWA_SR = 8
XC_HYB_GAUSSIAN_SR = 16

# possible types of hybrid functionals
XC_HYB_SEMILOCAL = 0
XC_HYB_HYBRID = 1
XC_HYB_CAM = 2
XC_HYB_CAMY = 3
XC_HYB_CAMG = 4
XC_HYB_DOUBLE_HYBRID = 5
XC_HYB_MIXTURE = 32768

XC_MAX_REFERENCES = 5

