
def init_logger(level: Optional[str] = "", format: Optional[str] = "") -> None
def SingleFieldPipeline(name: str, model: Optional[Model] = None, splitter: Optional[Splitter] = None, parameters: Optional[Json] = Any) -> Pipeline
async def migrate() -> None

Json = Any
DateTime = int
GeneralJsonIterator = Any
GeneralJsonAsyncIterator = Any

# Top of file key: A12BECOD!
from typing import List, Dict, Optional, Self, Any


class Builtins:
	def __init__(self, database_url: Optional[str] = "Default set in Rust. Please check the documentation.") -> Self
		...
	def query(self, query: str) -> QueryRunner
		...
	async def transform(self, task: Json, inputs: List[str], args: Optional[Json] = Any) -> Json
		...
	async def embed(self, model: str, text: str) -> Json
		...
	async def embed_batch(self, model: str, texts: Json) -> Json
		...

class RAGStream:
	def stream(self) -> GeneralJsonAsyncIterator
		...
	def sources(self) -> Json
		...

class Collection:
	def __init__(self, name: str, database_url: Optional[str] = "Default set in Rust. Please check the documentation.") -> Self
		...
	async def add_pipeline(self, pipeline: Pipeline) -> None
		...
	async def remove_pipeline(self, pipeline: Pipeline) -> None
		...
	async def enable_pipeline(self, pipeline: Pipeline) -> None
		...
	async def disable_pipeline(self, pipeline: Pipeline) -> None
		...
	async def upsert_documents(self, documents: List[Json], args: Optional[Json] = Any) -> None
		...
	async def get_documents(self, args: Optional[Json] = Any) -> List[Json]
		...
	async def delete_documents(self, filter: Json) -> None
		...
	async def search(self, query: Json, pipeline: Pipeline) -> Json
		...
	async def add_search_event(self, search_id: int, search_result: int, event: Json, pipeline: Pipeline) -> None
		...
	async def vector_search(self, query: Json, pipeline: Pipeline) -> List[Json]
		...
	async def rag(self, query: Json, pipeline: Pipeline) -> Json
		...
	async def rag_stream(self, query: Json, pipeline: Pipeline) -> RAGStream
		...
	async def archive(self) -> None
		...
	def query(self) -> QueryBuilder
		...
	async def get_pipelines(self) -> List[Pipeline]
		...
	async def get_pipeline(self, name: str) -> Pipeline
		...
	async def exists(self) -> bool
		...
	async def upsert_directory(self, path: str, args: Json) -> None
		...
	async def get_pipeline_status(self, pipeline: Pipeline) -> Json
		...
	async def generate_er_diagram(self, pipeline: Pipeline) -> str
		...
	async def upsert_file(self, path: str) -> None
		...

class Model:
	def __init__(self, name: Optional[str] = "Default set in Rust. Please check the documentation.", source: Optional[str] = "Default set in Rust. Please check the documentation.", parameters: Optional[Json] = Any) -> Self
		...

class OpenSourceAI:
	def __init__(self, database_url: Optional[str] = "Default set in Rust. Please check the documentation.") -> Self
		...
	async def chat_completions_create_stream_async(self, model: Json, messages: List[Json], max_tokens: Optional[Any] = Any, temperature: Optional[float] = 1, n: Optional[Any] = Any, chat_template: Optional[str] = "Default set in Rust. Please check the documentation.") -> GeneralJsonAsyncIterator
		...
	def chat_completions_create_stream(self, model: Json, messages: List[Json], max_tokens: Optional[Any] = Any, temperature: Optional[float] = 1, n: Optional[Any] = Any, chat_template: Optional[str] = "Default set in Rust. Please check the documentation.") -> GeneralJsonIterator
		...
	async def chat_completions_create_async(self, model: Json, messages: List[Json], max_tokens: Optional[Any] = Any, temperature: Optional[float] = 1, n: Optional[Any] = Any, chat_template: Optional[str] = "Default set in Rust. Please check the documentation.") -> Json
		...
	def chat_completions_create(self, model: Json, messages: List[Json], max_tokens: Optional[Any] = Any, temperature: Optional[float] = 1, n: Optional[Any] = Any, chat_template: Optional[str] = "Default set in Rust. Please check the documentation.") -> Json
		...

class Pipeline:
	def __init__(self, name: str, schema: Optional[Json] = Any) -> Self
		...

class QueryBuilder:
	def limit(self, limit: int) -> Self
		...
	def filter(self, filter: Json) -> Self
		...
	def vector_recall(self, query: str, pipeline: Pipeline, query_parameters: Optional[Json] = Any) -> Self
		...
	async def fetch_all(self) -> List[tuple[float, str, Json]]
		...

class QueryRunner:
	async def fetch_all(self) -> Json
		...
	async def execute(self) -> None
		...
	def bind_string(self, bind_value: str) -> Self
		...
	def bind_int(self, bind_value: int) -> Self
		...
	def bind_float(self, bind_value: float) -> Self
		...
	def bind_bool(self, bind_value: bool) -> Self
		...
	def bind_json(self, bind_value: Json) -> Self
		...

class Splitter:
	def __init__(self, name: Optional[str] = "Default set in Rust. Please check the documentation.", parameters: Optional[Json] = Any) -> Self
		...

class TransformerPipeline:
	def __init__(self, task: str, model: str, args: Optional[Json] = Any, database_url: Optional[str] = "Default set in Rust. Please check the documentation.") -> Self
		...
	async def transform(self, inputs: List[Json], args: Optional[Json] = Any) -> Json
		...
	async def transform_stream(self, input: Json, args: Optional[Json] = Any, batch_size: Optional[Any] = Any) -> GeneralJsonAsyncIterator
		...
