# Stubs for shutil
import sys

# Based on http://docs.python.org/3.2/library/shutil.html

# 'bytes' paths are not properly supported: they don't work with all functions,
# sometimes they only work partially (broken exception messages), and the test
# cases don't use them.

from typing import (
    List, Iterable, Callable, Any, Tuple, Sequence, NamedTuple, IO,
    AnyStr, Optional
)

def copyfileobj(fsrc: IO[AnyStr], fdst: IO[AnyStr],
                length: int = ...) -> None: ...

def copyfile(src: str, dst: str) -> None: ...

if sys.version_info >= (3, 3):
    def copymode(src: str, dst: str, *,
                 follow_symlinks: bool = ...) -> None: ...
    def copystat(src: str, dst: str, *,
                 follow_symlinks: bool = ...) -> None: ...
    def copy(src: str, dst: str, *,
             follow_symlinks: bool = ...) -> None: ...
    def copy2(src: str, dst: str, *,
              follow_symlinks: bool = ...) -> None: ...
else:
    def copymode(src: str, dst: str) -> None: ...
    def copystat(src: str, dst: str) -> None: ...
    def copy(src: str, dst: str) -> None: ...
    def copy2(src: str, dst: str) -> None: ...

def ignore_patterns(*patterns: str) -> Callable[[str, List[str]],
                                                Iterable[str]]: ...

if sys.version_info >= (3, 3):
    def copytree(src: str, dst: str, symlinks: bool = ...,
                 ignore: Optional[Callable[[str, List[str]],
                                           Iterable[str]]] = ...,
                 copy_function: Callable[[str, str], None] = ...,
                 ignore_dangling_symlinks: bool = ...) -> str: ...
else:
    def copytree(src: str, dst: str, symlinks: bool = ...,
                 ignore: Optional[Callable[[str, List[str]],
                                           Iterable[str]]] = ...,
                 copy_function: Callable[[str, str], None] = ...,
                 ignore_dangling_symlinks: bool = ...) -> None: ...

def rmtree(path: str, ignore_errors: bool = ...,
           onerror: Callable[[Any, str, Any], None] = ...) -> None: ...

if sys.version_info >= (3, 5):
    def move(src: str, dst: str,
             copy_function: Callable[[str, str], None] = ...) -> str: ...
elif sys.version_info >= (3, 3):
    def move(src: str, dst: str) -> str: ...
else:
    def move(src: str, dst: str) -> None: ...

if sys.version_info >= (3, 3):
    _ntuple_diskusage = NamedTuple('usage', [('total', int),
                                             ('used', int),
                                             ('free', int)])
    def disk_usage(path: str) -> _ntuple_diskusage: ...
    def chown(path: str, user: Optional[str] = ...,
              group: Optional[str] = ...) -> None: ...
    def which(cmd: str, mode: int = ...,
              path: Optional[str] = ...) -> Optional[str]: ...

class Error(Exception): ...
if sys.version_info >= (3, 4):
    class SameFileError(Error): ...

def make_archive(base_name: str, format: str, root_dir: str = ...,
                 base_dir: str = ..., verbose: bool = ...,
                 dry_run: bool = ..., owner: str = ..., group: str = ...,
                 logger: Any = ...) -> str: ...
def get_archive_formats() -> List[Tuple[str, str]]: ...
def register_archive_format(name: str, function: Any,
                            extra_args: Sequence[Tuple[str, Any]] = ...,
                            description: str = ...) -> None: ...
def unregister_archive_format(name: str) -> None: ...
def unpack_archive(filename: str, extract_dir: str = ...,
                   format: str = ...) -> None: ...
def register_unpack_format(name: str, extensions: List[str], function: Any,
                           extra_args: Sequence[Tuple[str, Any]] = ...,
                           description: str = ...) -> None: ...
def unregister_unpack_format(name: str) -> None: ...
def get_unpack_formats() -> List[Tuple[str, List[str], str]]: ...

if sys.version_info >= (3, 3):
    def get_terminal_size(fallback: Tuple[int, int] = ...) -> Tuple[int, int]: ...
