# Stubs for sqlalchemy.sql.elements (Python 2 and 3)
from typing import Text, Any

from .visitors import Visitable
from .annotation import Annotated
from .base import Executable, Immutable
from .operators import ColumnOperators
from .. import util

class ClauseElement(Visitable): ...

class ColumnElement(ColumnOperators, ClauseElement):
    __visit_name__ = 'column'  # type: Text
    primary_key = False  # type: Any
    foreign_keys = []  # type: Any
    _label = None  # type: Any
    _key_label = key = None  # type: Any
    _alt_names = ()  # type: Any
    def self_group(self, against=None): ...
    def _negate(self): ...
    @util.memoized_property
    def type(self): ...
    @util.memoized_property
    def comparator(self): ...
    def __getattr__(self, key): ...
    def operate(self, op, *other, **kwargs): ...
    def reverse_operate(self, op, other, **kwargs): ...
    def _bind_param(self, operator, obj): ...
    @property
    def expression(self): ...
    @property
    def _select_iterable(self): ...
    @util.memoized_property
    def base_columns(self): ...
    @util.memoized_property
    def proxy_set(self): ...
    def shares_lineage(self, othercolumn): ...
    def _compare_name_for_result(self, other): ...
    def _make_proxy(self, selectable, name=None, name_is_truncatable=False, **kw): ...
    def compare(self, other, use_proxies=False, equivalents=None, **kw): ...
    def label(self, name): ...
    @util.memoized_property
    def anon_label(self): ...

class BindParameter(ColumnElement): ...
class BinaryExpression(ColumnElement): ...

class TypeClause(ClauseElement): ...
class TextClause(Executable, ClauseElement): ...

class Null(ColumnElement): ...
class False_(ColumnElement): ...
class True_(ColumnElement): ...

class ClauseList(ClauseElement): ...
class BooleanClauseList(ClauseList, ColumnElement): ...
class Tuple(ClauseList, ColumnElement): ...
class Case(ColumnElement): ...
class Cast(ColumnElement): ...
class Extract(ColumnElement): ...
class _label_reference(ColumnElement): ...

class _textual_label_reference(ColumnElement): ...
class UnaryExpression(ColumnElement): ...
class AsBoolean(UnaryExpression): ...
class Grouping(ColumnElement): ...
class Over(ColumnElement): ...
class FunctionFilter(ColumnElement): ...
class Label(ColumnElement): ...
class ColumnClause(Immutable, ColumnElement): ...
class _IdentifiedClause(Executable, ClauseElement): ...
class SavepointClause(_IdentifiedClause): ...
class RollbackToSavepointClause(_IdentifiedClause): ...
class ReleaseSavepointClause(_IdentifiedClause): ...
class quoted_name(util.MemoizedSlots, util.text_type): ...
class _truncated_label(quoted_name): ...
class conv(_truncated_label): ...
class _defer_name(_truncated_label): ...
class _defer_none_name(_defer_name): ...
class _anonymous_label(_truncated_label): ...
class AnnotatedColumnElement(Annotated): ...

def _clone(element, **kw): ...
def _type_from_args(args): ...
def _literal_as_binds(element, name, type_=None): ...

def collate(expression, collation) -> BinaryExpression: ...
def between(expr, lower_bound, upper_bound, symmetric: bool=...): ...
def literal(value, type_=None) -> BindParameter: ...
def outparam(key, type_=None) -> BindParameter: ...
def type_coerce(expression, type_): ...
def not_(clause): ...
def literal_column(text, type_=None): ...
