from .type_api import TypeEngine, TypeDecorator
from .base import SchemaEventTarget

class _DateAffinity(object): ...
class Concatenable(object): ...
class String(TypeEngine, Concatenable):
    def __init__(self, length=None, collation=None,
                 convert_unicode=False,
                 unicode_error=None,
                 _warn_on_bytestring=False): ...

class Text(String): ...
class Unicode(String): ...
class UnicodeText(Text): ...
class Integer(TypeEngine, _DateAffinity): ...
class SmallInteger(Integer): ...
class BigInteger(Integer): ...
class Numeric(TypeEngine, _DateAffinity): ...
class Float(Numeric): ...
class DateTime(TypeEngine, _DateAffinity):
    def __init__(self, timezone=None): ...
class Date(TypeEngine, _DateAffinity): ...
class Time(TypeEngine, _DateAffinity): ...
class _Binary(TypeEngine): ...
class LargeBinary(_Binary): ...
class Binary(LargeBinary): ...
class SchemaType(SchemaEventTarget): ...
class Enum(String, SchemaType): ...
class PickleType(TypeDecorator): ...
class Boolean(TypeEngine, SchemaType): ...
class Interval(_DateAffinity, TypeDecorator): ...

class REAL(Float): ...
class FLOAT(Float): ...
class NUMERIC(Numeric): ...
class DECIMAL(Numeric): ...
class INTEGER(Integer): ...
# In code it's INT=INTEGER
class INT(Integer): ...
class SMALLINT(SmallInteger): ...
class BIGINT(BigInteger): ...
class TIMESTAMP(DateTime): ...
class DATETIME(DateTime): ...
class DATE(Date): ...
class TIME(Time): ...
class TEXT(Text): ...
class CLOB(Text): ...
class VARCHAR(String): ...
class NVARCHAR(Unicode): ...
class CHAR(String): ...
class NCHAR(Unicode): ...
class BLOB(LargeBinary): ...
class BINARY(_Binary): ...
class VARBINARY(_Binary): ...
class BOOLEAN(Boolean): ...
class NullType(TypeEngine): ...
class MatchType(Boolean): ...
