"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from datetime import datetime
from typing import Optional
from typing_extensions import NotRequired, TypedDict
from zendesk.types import BaseModel


class AuditLogObjectTypedDict(TypedDict):
    action: NotRequired[str]
    r"""Type of change made. Possible values are \"create\", \"destroy\", \"exported\", \"login\", and \"update\" 

    """
    action_label: NotRequired[str]
    r"""Localized string of action field"""
    actor_id: NotRequired[int]
    r"""id of the user or system that initiated the change"""
    actor_name: NotRequired[str]
    r"""Name of the user or system that initiated the change"""
    change_description: NotRequired[str]
    r"""The description of the change that occurred"""
    created_at: NotRequired[datetime]
    r"""The time the audit got created"""
    id: NotRequired[int]
    r"""The id automatically assigned upon creation"""
    ip_address: NotRequired[str]
    r"""The IP address of the user doing the audit"""
    source_id: NotRequired[int]
    r"""The id of the item being audited"""
    source_label: NotRequired[str]
    r"""The name of the item being audited"""
    source_type: NotRequired[str]
    r"""Item type being audited. Typically describes the system where the change
    was initiated. Possible values vary based on your account's Zendesk
    products and activity. Common values include \"apitoken\", \"rule\", \"ticket\",
    \"user\", and \"zendesk/app_market/app\". The \"rule\" value is used for
    [automations](https://support.zendesk.com/hc/en-us/articles/4408832701850),
    [macros](https://support.zendesk.com/hc/en-us/articles/4408844187034),
    [triggers](https://support.zendesk.com/hc/en-us/articles/4408822236058),
    [views](https://support.zendesk.com/hc/en-us/articles/4408888828570),
    and other automated business rules

    """
    url: NotRequired[str]
    r"""The URL to access the audit log"""


class AuditLogObject(BaseModel):
    action: Optional[str] = None
    r"""Type of change made. Possible values are \"create\", \"destroy\", \"exported\", \"login\", and \"update\" 

    """

    action_label: Optional[str] = None
    r"""Localized string of action field"""

    actor_id: Optional[int] = None
    r"""id of the user or system that initiated the change"""

    actor_name: Optional[str] = None
    r"""Name of the user or system that initiated the change"""

    change_description: Optional[str] = None
    r"""The description of the change that occurred"""

    created_at: Optional[datetime] = None
    r"""The time the audit got created"""

    id: Optional[int] = None
    r"""The id automatically assigned upon creation"""

    ip_address: Optional[str] = None
    r"""The IP address of the user doing the audit"""

    source_id: Optional[int] = None
    r"""The id of the item being audited"""

    source_label: Optional[str] = None
    r"""The name of the item being audited"""

    source_type: Optional[str] = None
    r"""Item type being audited. Typically describes the system where the change
    was initiated. Possible values vary based on your account's Zendesk
    products and activity. Common values include \"apitoken\", \"rule\", \"ticket\",
    \"user\", and \"zendesk/app_market/app\". The \"rule\" value is used for
    [automations](https://support.zendesk.com/hc/en-us/articles/4408832701850),
    [macros](https://support.zendesk.com/hc/en-us/articles/4408844187034),
    [triggers](https://support.zendesk.com/hc/en-us/articles/4408822236058),
    [views](https://support.zendesk.com/hc/en-us/articles/4408888828570),
    and other automated business rules

    """

    url: Optional[str] = None
    r"""The URL to access the audit log"""
