"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .customobjectrecordsresponse import (
    CustomObjectRecordsResponse,
    CustomObjectRecordsResponseTypedDict,
)
import pydantic
from typing import Callable, Optional
from typing_extensions import Annotated, NotRequired, TypedDict
from zendesk.types import BaseModel
from zendesk.utils import FieldMetadata, PathParamMetadata, QueryParamMetadata


class AutocompleteCustomObjectRecordSearchRequestTypedDict(TypedDict):
    custom_object_key: str
    r"""The key of a custom object"""
    name: NotRequired[str]
    r"""Part of a name of the record you are searching for"""
    page_before: NotRequired[str]
    r"""A [pagination cursor](/documentation/api-basics/pagination/paginating-through-lists-using-cursor-pagination) that tells the endpoint which page to start on. It should be a `meta.before_cursor` value from a previous request. Note: `page[before]` and `page[after]` can't be used together in the same request.

    """
    page_after: NotRequired[str]
    r"""A [pagination cursor](/documentation/api-basics/pagination/paginating-through-lists-using-cursor-pagination) that tells the endpoint which page to start on. It should be a `meta.after_cursor` value from a previous request. Note: `page[before]` and `page[after]` can't be used together in the same request.

    """
    page_size: NotRequired[int]
    r"""The number of records to return in the response. You can specify up to 100 records per page.

    """
    field_id: NotRequired[str]
    r"""The id of the lookup field. If the field has a relationship filter, the filter is applied to the results. Must be used with `source` param.

    """
    source: NotRequired[str]
    r"""One of \"zen:user\", \"zen:ticket\", \"zen:organization\", or \"zen:custom_object:CUSTOM_OBJECT_KEY\". Represents the object `field_id` belongs to. Must be used with field_id param.

    """
    requester_id: NotRequired[int]
    r"""The id of the requester. For use with dynamic filters.

    """
    assignee_id: NotRequired[int]
    r"""The id of the selected assignee. For use with dynamic filters.

    """
    organization_id: NotRequired[int]
    r"""The id of the organization the requester belongs to. For use with dynamic filters.

    """


class AutocompleteCustomObjectRecordSearchRequest(BaseModel):
    custom_object_key: Annotated[
        str, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))
    ]
    r"""The key of a custom object"""

    name: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Part of a name of the record you are searching for"""

    page_before: Annotated[
        Optional[str],
        pydantic.Field(alias="page[before]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""A [pagination cursor](/documentation/api-basics/pagination/paginating-through-lists-using-cursor-pagination) that tells the endpoint which page to start on. It should be a `meta.before_cursor` value from a previous request. Note: `page[before]` and `page[after]` can't be used together in the same request.

    """

    page_after: Annotated[
        Optional[str],
        pydantic.Field(alias="page[after]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""A [pagination cursor](/documentation/api-basics/pagination/paginating-through-lists-using-cursor-pagination) that tells the endpoint which page to start on. It should be a `meta.after_cursor` value from a previous request. Note: `page[before]` and `page[after]` can't be used together in the same request.

    """

    page_size: Annotated[
        Optional[int],
        pydantic.Field(alias="page[size]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The number of records to return in the response. You can specify up to 100 records per page.

    """

    field_id: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The id of the lookup field. If the field has a relationship filter, the filter is applied to the results. Must be used with `source` param.

    """

    source: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""One of \"zen:user\", \"zen:ticket\", \"zen:organization\", or \"zen:custom_object:CUSTOM_OBJECT_KEY\". Represents the object `field_id` belongs to. Must be used with field_id param.

    """

    requester_id: Annotated[
        Optional[int],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The id of the requester. For use with dynamic filters.

    """

    assignee_id: Annotated[
        Optional[int],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The id of the selected assignee. For use with dynamic filters.

    """

    organization_id: Annotated[
        Optional[int],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The id of the organization the requester belongs to. For use with dynamic filters.

    """


class AutocompleteCustomObjectRecordSearchResponseTypedDict(TypedDict):
    result: CustomObjectRecordsResponseTypedDict


class AutocompleteCustomObjectRecordSearchResponse(BaseModel):
    next: Callable[[], Optional[AutocompleteCustomObjectRecordSearchResponse]]

    result: CustomObjectRecordsResponse
