"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .attachmentobject import AttachmentObject, AttachmentObjectTypedDict
from datetime import datetime
from enum import Enum
import pydantic
from pydantic import ConfigDict
from typing import Any, Dict, List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict
from zendesk.types import BaseModel


class ConversationLogObjectType(str, Enum):
    r"""Either user, agent, or bot"""

    USER = "user"
    AGENT = "agent"
    BOT = "bot"


class ConversationLogObjectAuthorTypedDict(TypedDict):
    r"""Object that describes the user who created the event"""

    type: NotRequired[ConversationLogObjectType]
    r"""Either user, agent, or bot"""
    zen_sunco_user_id: NotRequired[str]
    r"""A Zendesk resource name prefix describing a messaging user"""
    zen_support_user_id: NotRequired[int]
    r"""A Zendesk resource name prefix describing a Support user"""


class ConversationLogObjectAuthor(BaseModel):
    r"""Object that describes the user who created the event"""

    model_config = ConfigDict(
        populate_by_name=True, arbitrary_types_allowed=True, extra="allow"
    )
    __pydantic_extra__: Dict[str, Any] = pydantic.Field(init=False)

    type: Optional[ConversationLogObjectType] = None
    r"""Either user, agent, or bot"""

    zen_sunco_user_id: Annotated[
        Optional[str], pydantic.Field(alias="zen:sunco:user_id")
    ] = None
    r"""A Zendesk resource name prefix describing a messaging user"""

    zen_support_user_id: Annotated[
        Optional[int], pydantic.Field(alias="zen:support:user_id")
    ] = None
    r"""A Zendesk resource name prefix describing a Support user"""

    @property
    def additional_properties(self):
        return self.__pydantic_extra__

    @additional_properties.setter
    def additional_properties(self, value):
        self.__pydantic_extra__ = value  # pyright: ignore[reportIncompatibleVariableOverride]


class ConversationLogObjectTypedDict(TypedDict):
    attachments: List[AttachmentObjectTypedDict]
    r"""A collection of attachments (image or file) associated with the event"""
    author: ConversationLogObjectAuthorTypedDict
    r"""Object that describes the user who created the event"""
    content: Dict[str, Any]
    r"""Object that describes the content of the message. The inner fields depends on the record type"""
    created_at: datetime
    r"""The timestamp of when this record was created"""
    id: str
    r"""Unique record identifier"""
    metadata: Dict[str, Any]
    r"""Various additional data that further describes this record"""
    reference: str
    r"""A Zendesk resource name value that uniquely identifies this record. Example: `zen:ticket_event:<id>`"""
    type: str
    r"""The type of record, representing one of the conversational ticket events. Examples: `Comment` or `Messaging::ConversationMessage`"""


class ConversationLogObject(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True, arbitrary_types_allowed=True, extra="allow"
    )
    __pydantic_extra__: Dict[str, Any] = pydantic.Field(init=False)

    attachments: List[AttachmentObject]
    r"""A collection of attachments (image or file) associated with the event"""

    author: ConversationLogObjectAuthor
    r"""Object that describes the user who created the event"""

    content: Dict[str, Any]
    r"""Object that describes the content of the message. The inner fields depends on the record type"""

    created_at: datetime
    r"""The timestamp of when this record was created"""

    id: str
    r"""Unique record identifier"""

    metadata: Dict[str, Any]
    r"""Various additional data that further describes this record"""

    reference: str
    r"""A Zendesk resource name value that uniquely identifies this record. Example: `zen:ticket_event:<id>`"""

    type: str
    r"""The type of record, representing one of the conversational ticket events. Examples: `Comment` or `Messaging::ConversationMessage`"""

    @property
    def additional_properties(self):
        return self.__pydantic_extra__

    @additional_properties.setter
    def additional_properties(self, value):
        self.__pydantic_extra__ = value  # pyright: ignore[reportIncompatibleVariableOverride]
