"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .userrolefilter import UserRoleFilter
import pydantic
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict
from zendesk.types import BaseModel
from zendesk.utils import FieldMetadata, QueryParamMetadata


class CountUsersRequestTypedDict(TypedDict):
    role_query_parameter: NotRequired[UserRoleFilter]
    r"""Filters the results by role. Possible values are \"end-user\", \"agent\", or \"admin\" 

    """
    role_query_parameter1: NotRequired[str]
    r"""Filters the results by more than one role using the format `role[]={role}&role[]={role}`

    """
    permission_set: NotRequired[int]
    r"""For custom roles which is available on the Enterprise plan and above. You can only filter by one role ID per request"""


class CountUsersRequest(BaseModel):
    role_query_parameter: Annotated[
        Optional[UserRoleFilter],
        pydantic.Field(alias="role"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Filters the results by role. Possible values are \"end-user\", \"agent\", or \"admin\" 

    """

    role_query_parameter1: Annotated[
        Optional[str],
        pydantic.Field(alias="role[]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Filters the results by more than one role using the format `role[]={role}&role[]={role}`

    """

    permission_set: Annotated[
        Optional[int],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""For custom roles which is available on the Enterprise plan and above. You can only filter by one role ID per request"""
