"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .ticketobject import TicketObject, TicketObjectTypedDict
from pydantic import model_serializer
from typing import List, Optional
from typing_extensions import NotRequired, TypedDict
from zendesk.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL


class CursorBasedExportIncrementalTicketsResponseTypedDict(TypedDict):
    r"""See [Tickets](/api-reference/ticketing/tickets/tickets/) for a detailed example."""

    after_cursor: NotRequired[Nullable[str]]
    after_url: NotRequired[Nullable[str]]
    before_cursor: NotRequired[Nullable[str]]
    before_url: NotRequired[Nullable[str]]
    end_of_stream: NotRequired[bool]
    tickets: NotRequired[List[TicketObjectTypedDict]]


class CursorBasedExportIncrementalTicketsResponse(BaseModel):
    r"""See [Tickets](/api-reference/ticketing/tickets/tickets/) for a detailed example."""

    after_cursor: OptionalNullable[str] = UNSET

    after_url: OptionalNullable[str] = UNSET

    before_cursor: OptionalNullable[str] = UNSET

    before_url: OptionalNullable[str] = UNSET

    end_of_stream: Optional[bool] = None

    tickets: Optional[List[TicketObject]] = None

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "after_cursor",
            "after_url",
            "before_cursor",
            "before_url",
            "end_of_stream",
            "tickets",
        ]
        nullable_fields = ["after_cursor", "after_url", "before_cursor", "before_url"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
