"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from datetime import datetime
from typing import Optional
from typing_extensions import NotRequired, TypedDict
from zendesk.types import BaseModel


class CustomObjectTypedDict(TypedDict):
    include_in_list_view: bool
    r"""A flag setting the visibility of the object in the agent's list view. If true, all agents and admins have viewing access to the object in the Custom objects record page in the Agent Workspace. If false, only admins have viewing access"""
    key: str
    r"""A user-defined unique identifier. Writable on create only"""
    title: str
    r"""User-defined display name for the object"""
    title_pluralized: str
    r"""User-defined pluralized version of the object's title"""
    allows_photos: NotRequired[bool]
    r"""If true, photos can be uploaded to the records of the object. If false, new photos cannot be uploaded but existing photos can still be viewed and removed"""
    created_at: NotRequired[datetime]
    r"""The time the object type was created"""
    created_by_user_id: NotRequired[str]
    r"""Id of a user who created the object"""
    description: NotRequired[str]
    r"""User-defined description of the object"""
    raw_description: NotRequired[str]
    r"""The dynamic content placeholder, if present, or the \"raw_description\" value, if not. See [Dynamic Content Items](/api-reference/ticketing/ticket-management/dynamic_content/)"""
    raw_title: NotRequired[str]
    r"""The dynamic content placeholder, if present, or the \"title\" value, if not. See [Dynamic Content Items](/api-reference/ticketing/ticket-management/dynamic_content/)"""
    raw_title_pluralized: NotRequired[str]
    r"""The dynamic content placeholder, if present, or the \"raw_title_pluralized\" value, if not. See [Dynamic Content Items](/api-reference/ticketing/ticket-management/dynamic_content/)"""
    updated_at: NotRequired[datetime]
    r"""The time of the last update of the object"""
    updated_by_user_id: NotRequired[str]
    r"""Id of the last user who updated the object"""
    url: NotRequired[str]
    r"""Direct link to the specific custom object"""


class CustomObject(BaseModel):
    include_in_list_view: bool
    r"""A flag setting the visibility of the object in the agent's list view. If true, all agents and admins have viewing access to the object in the Custom objects record page in the Agent Workspace. If false, only admins have viewing access"""

    key: str
    r"""A user-defined unique identifier. Writable on create only"""

    title: str
    r"""User-defined display name for the object"""

    title_pluralized: str
    r"""User-defined pluralized version of the object's title"""

    allows_photos: Optional[bool] = None
    r"""If true, photos can be uploaded to the records of the object. If false, new photos cannot be uploaded but existing photos can still be viewed and removed"""

    created_at: Optional[datetime] = None
    r"""The time the object type was created"""

    created_by_user_id: Optional[str] = None
    r"""Id of a user who created the object"""

    description: Optional[str] = None
    r"""User-defined description of the object"""

    raw_description: Optional[str] = None
    r"""The dynamic content placeholder, if present, or the \"raw_description\" value, if not. See [Dynamic Content Items](/api-reference/ticketing/ticket-management/dynamic_content/)"""

    raw_title: Optional[str] = None
    r"""The dynamic content placeholder, if present, or the \"title\" value, if not. See [Dynamic Content Items](/api-reference/ticketing/ticket-management/dynamic_content/)"""

    raw_title_pluralized: Optional[str] = None
    r"""The dynamic content placeholder, if present, or the \"raw_title_pluralized\" value, if not. See [Dynamic Content Items](/api-reference/ticketing/ticket-management/dynamic_content/)"""

    updated_at: Optional[datetime] = None
    r"""The time of the last update of the object"""

    updated_by_user_id: Optional[str] = None
    r"""Id of the last user who updated the object"""

    url: Optional[str] = None
    r"""Direct link to the specific custom object"""
