"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from datetime import datetime
from pydantic import model_serializer
from typing import Any, Dict, Optional
from typing_extensions import NotRequired, TypedDict
from zendesk.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL


class CustomObjectRecordTypedDict(TypedDict):
    name: str
    r"""User-defined display name for the object. If autonumbering is selected for the custom object's name field, the name isn't allowed because it's automatically generated. If uniqueness is enabled, the name must be unique."""
    created_at: NotRequired[datetime]
    r"""The time the object was created"""
    created_by_user_id: NotRequired[str]
    r"""Id of a user who created the object"""
    custom_object_fields: NotRequired[Dict[str, Any]]
    custom_object_key: NotRequired[str]
    r"""A user-defined unique identifier"""
    external_id: NotRequired[Nullable[str]]
    r"""An id you can use to link custom object records to external data"""
    id: NotRequired[str]
    r"""Automatically assigned upon creation"""
    photo: NotRequired[Nullable[Dict[str, Any]]]
    r"""The record photo represented as an [Attachment](/api-reference/ticketing/tickets/ticket-attachments/). The `allows_photos` property must be set to `true` for the object"""
    updated_at: NotRequired[datetime]
    r"""The time of the last update of the object"""
    updated_by_user_id: NotRequired[str]
    r"""Id of the last user who updated the object"""
    url: NotRequired[str]
    r"""Direct link to the specific custom object"""


class CustomObjectRecord(BaseModel):
    name: str
    r"""User-defined display name for the object. If autonumbering is selected for the custom object's name field, the name isn't allowed because it's automatically generated. If uniqueness is enabled, the name must be unique."""

    created_at: Optional[datetime] = None
    r"""The time the object was created"""

    created_by_user_id: Optional[str] = None
    r"""Id of a user who created the object"""

    custom_object_fields: Optional[Dict[str, Any]] = None

    custom_object_key: Optional[str] = None
    r"""A user-defined unique identifier"""

    external_id: OptionalNullable[str] = UNSET
    r"""An id you can use to link custom object records to external data"""

    id: Optional[str] = None
    r"""Automatically assigned upon creation"""

    photo: OptionalNullable[Dict[str, Any]] = UNSET
    r"""The record photo represented as an [Attachment](/api-reference/ticketing/tickets/ticket-attachments/). The `allows_photos` property must be set to `true` for the object"""

    updated_at: Optional[datetime] = None
    r"""The time of the last update of the object"""

    updated_by_user_id: Optional[str] = None
    r"""Id of the last user who updated the object"""

    url: Optional[str] = None
    r"""Direct link to the specific custom object"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "created_at",
            "created_by_user_id",
            "custom_object_fields",
            "custom_object_key",
            "external_id",
            "id",
            "photo",
            "updated_at",
            "updated_by_user_id",
            "url",
        ]
        nullable_fields = ["external_id", "photo"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
