"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .recipientobject import RecipientObject, RecipientObjectTypedDict
from datetime import datetime
from typing import List, Optional
from typing_extensions import NotRequired, TypedDict
from zendesk.types import BaseModel


class EmailNotificationObjectTypedDict(TypedDict):
    comment_id: NotRequired[int]
    r"""The comment ID associated to this email notification"""
    created_at: NotRequired[datetime]
    r"""When this email notification was created"""
    email_id: NotRequired[str]
    r"""The email ID of this email notification"""
    message_id: NotRequired[str]
    r"""The value of the Message-Id header of the email"""
    notification_id: NotRequired[int]
    r"""The notification id of this email notification"""
    recipients: NotRequired[List[RecipientObjectTypedDict]]
    r"""The list of recipients associated to this email notification"""
    ticket_id: NotRequired[int]
    r"""The ticket ID associated to this email notification"""
    updated_at: NotRequired[datetime]
    r"""When this email notification was last updated"""
    url: NotRequired[str]
    r"""The API url of this email notification"""


class EmailNotificationObject(BaseModel):
    comment_id: Optional[int] = None
    r"""The comment ID associated to this email notification"""

    created_at: Optional[datetime] = None
    r"""When this email notification was created"""

    email_id: Optional[str] = None
    r"""The email ID of this email notification"""

    message_id: Optional[str] = None
    r"""The value of the Message-Id header of the email"""

    notification_id: Optional[int] = None
    r"""The notification id of this email notification"""

    recipients: Optional[List[RecipientObject]] = None
    r"""The list of recipients associated to this email notification"""

    ticket_id: Optional[int] = None
    r"""The ticket ID associated to this email notification"""

    updated_at: Optional[datetime] = None
    r"""When this email notification was last updated"""

    url: Optional[str] = None
    r"""The API url of this email notification"""
