"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from datetime import datetime
from typing import Optional
from typing_extensions import NotRequired, TypedDict
from zendesk.types import BaseModel


class GroupObjectTypedDict(TypedDict):
    name: str
    r"""The name of the group"""
    created_at: NotRequired[datetime]
    r"""The time the group was created"""
    default: NotRequired[bool]
    r"""If the group is the default one for the account"""
    deleted: NotRequired[bool]
    r"""Deleted groups get marked as such"""
    description: NotRequired[str]
    r"""The description of the group"""
    id: NotRequired[int]
    r"""Automatically assigned when creating groups"""
    is_public: NotRequired[bool]
    r"""If true, the group is public.
    If false, the group is private.
    You can't change a private group to a public group

    """
    updated_at: NotRequired[datetime]
    r"""The time of the last update of the group"""
    url: NotRequired[str]
    r"""The API url of the group"""


class GroupObject(BaseModel):
    name: str
    r"""The name of the group"""

    created_at: Optional[datetime] = None
    r"""The time the group was created"""

    default: Optional[bool] = None
    r"""If the group is the default one for the account"""

    deleted: Optional[bool] = None
    r"""Deleted groups get marked as such"""

    description: Optional[str] = None
    r"""The description of the group"""

    id: Optional[int] = None
    r"""Automatically assigned when creating groups"""

    is_public: Optional[bool] = None
    r"""If true, the group is public.
    If false, the group is private.
    You can't change a private group to a public group

    """

    updated_at: Optional[datetime] = None
    r"""The time of the last update of the group"""

    url: Optional[str] = None
    r"""The API url of the group"""
