"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .groupslapolicyfilterobject import (
    GroupSLAPolicyFilterObject,
    GroupSLAPolicyFilterObjectTypedDict,
)
from .groupslapolicymetricobject import (
    GroupSLAPolicyMetricObject,
    GroupSLAPolicyMetricObjectTypedDict,
)
from datetime import datetime
import pydantic
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict
from zendesk.types import BaseModel


class GroupSLAPolicyObjectTypedDict(TypedDict):
    filter_: GroupSLAPolicyFilterObjectTypedDict
    r"""An object that describes the conditions a ticket must match for a Group SLA policy to be applied to the ticket. See [Filter](#filter)."""
    title: str
    r"""The title of the Group SLA policy"""
    created_at: NotRequired[datetime]
    r"""The time the Group SLA policy was created"""
    description: NotRequired[str]
    r"""The description of the Group SLA policy"""
    id: NotRequired[str]
    r"""Automatically assigned when created"""
    policy_metrics: NotRequired[List[GroupSLAPolicyMetricObjectTypedDict]]
    r"""Array of [policy metric](#policy-metric) objects"""
    position: NotRequired[int]
    r"""Position of the Group SLA policy. This position determines the order in which policies are matched to tickets. If not specified, the Group SLA policy is added at the last position"""
    updated_at: NotRequired[datetime]
    r"""The time of the last update of the Group SLA policy"""
    url: NotRequired[str]
    r"""URL of the Group SLA policy record"""


class GroupSLAPolicyObject(BaseModel):
    filter_: Annotated[GroupSLAPolicyFilterObject, pydantic.Field(alias="filter")]
    r"""An object that describes the conditions a ticket must match for a Group SLA policy to be applied to the ticket. See [Filter](#filter)."""

    title: str
    r"""The title of the Group SLA policy"""

    created_at: Optional[datetime] = None
    r"""The time the Group SLA policy was created"""

    description: Optional[str] = None
    r"""The description of the Group SLA policy"""

    id: Optional[str] = None
    r"""Automatically assigned when created"""

    policy_metrics: Optional[List[GroupSLAPolicyMetricObject]] = None
    r"""Array of [policy metric](#policy-metric) objects"""

    position: Optional[int] = None
    r"""Position of the Group SLA policy. This position determines the order in which policies are matched to tickets. If not specified, the Group SLA policy is added at the last position"""

    updated_at: Optional[datetime] = None
    r"""The time of the last update of the Group SLA policy"""

    url: Optional[str] = None
    r"""URL of the Group SLA policy record"""
