"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .jobstatusresultobject import JobStatusResultObject, JobStatusResultObjectTypedDict
from pydantic import model_serializer
from typing import List, Optional, Union
from typing_extensions import NotRequired, TypeAliasType, TypedDict
from zendesk.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL


class JobStatusObjectResultsTypedDict(TypedDict):
    success: bool
    r"""Whether the action was successful or not"""


class JobStatusObjectResults(BaseModel):
    success: bool
    r"""Whether the action was successful or not"""


ResultsTypedDict = TypeAliasType(
    "ResultsTypedDict",
    Union[JobStatusObjectResultsTypedDict, List[JobStatusResultObjectTypedDict]],
)
r"""Result data from processed tasks. See [Results](#results) below"""


Results = TypeAliasType(
    "Results", Union[JobStatusObjectResults, List[JobStatusResultObject]]
)
r"""Result data from processed tasks. See [Results](#results) below"""


class JobStatusObjectTypedDict(TypedDict):
    id: NotRequired[str]
    r"""Automatically assigned when the job is queued"""
    job_type: NotRequired[str]
    r"""The type of the job"""
    message: NotRequired[Nullable[str]]
    r"""Message from the job worker, if any"""
    progress: NotRequired[Nullable[int]]
    r"""Number of tasks that have already been completed"""
    results: NotRequired[Nullable[ResultsTypedDict]]
    r"""Result data from processed tasks. See [Results](#results) below"""
    status: NotRequired[str]
    r"""The current status. One of the following: \"queued\", \"working\", \"failed\", \"completed\" """
    total: NotRequired[Nullable[int]]
    r"""The total number of tasks this job is batching through"""
    url: NotRequired[str]
    r"""The URL to poll for status updates"""


class JobStatusObject(BaseModel):
    id: Optional[str] = None
    r"""Automatically assigned when the job is queued"""

    job_type: Optional[str] = None
    r"""The type of the job"""

    message: OptionalNullable[str] = UNSET
    r"""Message from the job worker, if any"""

    progress: OptionalNullable[int] = UNSET
    r"""Number of tasks that have already been completed"""

    results: OptionalNullable[Results] = UNSET
    r"""Result data from processed tasks. See [Results](#results) below"""

    status: Optional[str] = None
    r"""The current status. One of the following: \"queued\", \"working\", \"failed\", \"completed\" """

    total: OptionalNullable[int] = UNSET
    r"""The total number of tasks this job is batching through"""

    url: Optional[str] = None
    r"""The URL to poll for status updates"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "id",
            "job_type",
            "message",
            "progress",
            "results",
            "status",
            "total",
            "url",
        ]
        nullable_fields = ["message", "progress", "results", "total"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
