"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict
from zendesk.types import BaseModel
from zendesk.utils import FieldMetadata, QueryParamMetadata


class ListActiveViewsRequestTypedDict(TypedDict):
    access: NotRequired[str]
    r"""Only views with given access. May be \"personal\", \"shared\", or \"account\" """
    group_id: NotRequired[int]
    r"""Only views belonging to given group"""
    sort_by: NotRequired[str]
    r"""Possible values are \"alphabetical\", \"created_at\", or \"updated_at\". Defaults to \"position\" """
    sort_order: NotRequired[str]
    r"""One of \"asc\" or \"desc\". Defaults to \"asc\" for alphabetical and position sort, \"desc\" for all others"""


class ListActiveViewsRequest(BaseModel):
    access: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Only views with given access. May be \"personal\", \"shared\", or \"account\" """

    group_id: Annotated[
        Optional[int],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Only views belonging to given group"""

    sort_by: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Possible values are \"alphabetical\", \"created_at\", or \"updated_at\". Defaults to \"position\" """

    sort_order: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""One of \"asc\" or \"desc\". Defaults to \"asc\" for alphabetical and position sort, \"desc\" for all others"""
