"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from pydantic import model_serializer
from typing import List, Optional
from typing_extensions import NotRequired, TypedDict
from zendesk.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL


class ListDeletedTicketsResponseActorTypedDict(TypedDict):
    id: NotRequired[int]
    name: NotRequired[str]


class ListDeletedTicketsResponseActor(BaseModel):
    id: Optional[int] = None

    name: Optional[str] = None


class DeletedTicketTypedDict(TypedDict):
    actor: NotRequired[ListDeletedTicketsResponseActorTypedDict]
    deleted_at: NotRequired[str]
    id: NotRequired[int]
    previous_state: NotRequired[str]
    subject: NotRequired[str]


class DeletedTicket(BaseModel):
    actor: Optional[ListDeletedTicketsResponseActor] = None

    deleted_at: Optional[str] = None

    id: Optional[int] = None

    previous_state: Optional[str] = None

    subject: Optional[str] = None


class ListDeletedTicketsResponseTypedDict(TypedDict):
    deleted_tickets: NotRequired[List[DeletedTicketTypedDict]]
    count: NotRequired[int]
    r"""the total record count"""
    next_page: NotRequired[Nullable[str]]
    r"""the URL of the next page"""
    previous_page: NotRequired[Nullable[str]]
    r"""the URL of the previous page"""


class ListDeletedTicketsResponse(BaseModel):
    deleted_tickets: Optional[List[DeletedTicket]] = None

    count: Optional[int] = None
    r"""the total record count"""

    next_page: OptionalNullable[str] = UNSET
    r"""the URL of the next page"""

    previous_page: OptionalNullable[str] = UNSET
    r"""the URL of the previous page"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["deleted_tickets", "count", "next_page", "previous_page"]
        nullable_fields = ["next_page", "previous_page"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
