"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .satisfactionratingsresponse import (
    SatisfactionRatingsResponse,
    SatisfactionRatingsResponseTypedDict,
)
from enum import Enum
import pydantic
from typing import Callable, Optional
from typing_extensions import Annotated, NotRequired, TypedDict
from zendesk.types import BaseModel
from zendesk.utils import FieldMetadata, QueryParamMetadata


class Score(str, Enum):
    r"""Filters the results by score. Possible values are \"offered\", \"unoffered\", \"received\", \"received_with_comment\", \"received_without_comment\", \"good\", \"good_with_comment\", \"good_without_comment\", \"bad\", \"bad_with_comment\", \"bad_without_comment\" """

    OFFERED = "offered"
    UNOFFERED = "unoffered"
    RECEIVED = "received"
    RECEIVED_WITH_COMMENT = "received_with_comment"
    RECEIVED_WITHOUT_COMMENT = "received_without_comment"
    GOOD = "good"
    GOOD_WITH_COMMENT = "good_with_comment"
    GOOD_WITHOUT_COMMENT = "good_without_comment"
    BAD = "bad"
    BAD_WITH_COMMENT = "bad_with_comment"
    BAD_WITHOUT_COMMENT = "bad_without_comment"


class ListSatisfactionRatingsRequestTypedDict(TypedDict):
    page_before: NotRequired[str]
    r"""A [pagination cursor](/documentation/api-basics/pagination/paginating-through-lists-using-cursor-pagination) that tells the endpoint which page to start on. It should be a `meta.before_cursor` value from a previous request. Note: `page[before]` and `page[after]` can't be used together in the same request.

    """
    page_after: NotRequired[str]
    r"""A [pagination cursor](/documentation/api-basics/pagination/paginating-through-lists-using-cursor-pagination) that tells the endpoint which page to start on. It should be a `meta.after_cursor` value from a previous request. Note: `page[before]` and `page[after]` can't be used together in the same request.

    """
    page_size: NotRequired[int]
    r"""Specifies how many records should be returned in the response. You can specify up to 100 records per page.

    """
    score: NotRequired[Score]
    r"""Filters the results by score. Possible values are \"offered\", \"unoffered\", \"received\", \"received_with_comment\", \"received_without_comment\", \"good\", \"good_with_comment\", \"good_without_comment\", \"bad\", \"bad_with_comment\", \"bad_without_comment\" 

    """
    start_time: NotRequired[int]
    r"""Time of the oldest satisfaction rating, as a [Unix epoch time](https://www.epochconverter.com/)

    """
    end_time: NotRequired[int]
    r"""Time of the most recent satisfaction rating, as a [Unix epoch time](https://www.epochconverter.com/)

    """


class ListSatisfactionRatingsRequest(BaseModel):
    page_before: Annotated[
        Optional[str],
        pydantic.Field(alias="page[before]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""A [pagination cursor](/documentation/api-basics/pagination/paginating-through-lists-using-cursor-pagination) that tells the endpoint which page to start on. It should be a `meta.before_cursor` value from a previous request. Note: `page[before]` and `page[after]` can't be used together in the same request.

    """

    page_after: Annotated[
        Optional[str],
        pydantic.Field(alias="page[after]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""A [pagination cursor](/documentation/api-basics/pagination/paginating-through-lists-using-cursor-pagination) that tells the endpoint which page to start on. It should be a `meta.after_cursor` value from a previous request. Note: `page[before]` and `page[after]` can't be used together in the same request.

    """

    page_size: Annotated[
        Optional[int],
        pydantic.Field(alias="page[size]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = 100
    r"""Specifies how many records should be returned in the response. You can specify up to 100 records per page.

    """

    score: Annotated[
        Optional[Score],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Filters the results by score. Possible values are \"offered\", \"unoffered\", \"received\", \"received_with_comment\", \"received_without_comment\", \"good\", \"good_with_comment\", \"good_without_comment\", \"bad\", \"bad_with_comment\", \"bad_without_comment\" 

    """

    start_time: Annotated[
        Optional[int],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Time of the oldest satisfaction rating, as a [Unix epoch time](https://www.epochconverter.com/)

    """

    end_time: Annotated[
        Optional[int],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Time of the most recent satisfaction rating, as a [Unix epoch time](https://www.epochconverter.com/)

    """


class ListSatisfactionRatingsResponseTypedDict(TypedDict):
    result: SatisfactionRatingsResponseTypedDict


class ListSatisfactionRatingsResponse(BaseModel):
    next: Callable[[], Optional[ListSatisfactionRatingsResponse]]

    result: SatisfactionRatingsResponse
