"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .ticketcommentsresponse import (
    TicketCommentsResponse,
    TicketCommentsResponseTypedDict,
)
from enum import Enum
import pydantic
from typing import Callable, Optional
from typing_extensions import Annotated, NotRequired, TypedDict
from zendesk.types import BaseModel
from zendesk.utils import FieldMetadata, PathParamMetadata, QueryParamMetadata


class ListTicketCommentsSort(str, Enum):
    r"""Sort order - \"created_at\" (ascending) or \"-created_at\" (descending)"""

    CREATED_AT = "created_at"
    MINUS_CREATED_AT = "-created_at"


class ListTicketCommentsRequestTypedDict(TypedDict):
    ticket_id: int
    r"""The ID of the ticket"""
    page_before: NotRequired[str]
    r"""A [pagination cursor](/documentation/api-basics/pagination/paginating-through-lists-using-cursor-pagination) that tells the endpoint which page to start on. It should be a `meta.before_cursor` value from a previous request. Note: `page[before]` and `page[after]` can't be used together in the same request.

    """
    page_after: NotRequired[str]
    r"""A [pagination cursor](/documentation/api-basics/pagination/paginating-through-lists-using-cursor-pagination) that tells the endpoint which page to start on. It should be a `meta.after_cursor` value from a previous request. Note: `page[before]` and `page[after]` can't be used together in the same request.

    """
    page_size: NotRequired[int]
    r"""Specifies how many records should be returned in the response. You can specify up to 100 records per page.

    """
    sort: NotRequired[ListTicketCommentsSort]
    r"""Sort order - \"created_at\" (ascending) or \"-created_at\" (descending)"""
    include_inline_images: NotRequired[bool]
    r"""Default is false. When true, inline images are also listed as attachments in the response"""
    include: NotRequired[str]
    r"""Accepts \"users\". Use this parameter to list email CCs by side-loading users. Example: `?include=users`. **Note**: If the comment source is email, a deleted user will be represented as the CCd email address. If the comment source is anything else, a deleted user will be represented as the user name."""


class ListTicketCommentsRequest(BaseModel):
    ticket_id: Annotated[
        int, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))
    ]
    r"""The ID of the ticket"""

    page_before: Annotated[
        Optional[str],
        pydantic.Field(alias="page[before]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""A [pagination cursor](/documentation/api-basics/pagination/paginating-through-lists-using-cursor-pagination) that tells the endpoint which page to start on. It should be a `meta.before_cursor` value from a previous request. Note: `page[before]` and `page[after]` can't be used together in the same request.

    """

    page_after: Annotated[
        Optional[str],
        pydantic.Field(alias="page[after]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""A [pagination cursor](/documentation/api-basics/pagination/paginating-through-lists-using-cursor-pagination) that tells the endpoint which page to start on. It should be a `meta.after_cursor` value from a previous request. Note: `page[before]` and `page[after]` can't be used together in the same request.

    """

    page_size: Annotated[
        Optional[int],
        pydantic.Field(alias="page[size]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = 100
    r"""Specifies how many records should be returned in the response. You can specify up to 100 records per page.

    """

    sort: Annotated[
        Optional[ListTicketCommentsSort],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = ListTicketCommentsSort.CREATED_AT
    r"""Sort order - \"created_at\" (ascending) or \"-created_at\" (descending)"""

    include_inline_images: Annotated[
        Optional[bool],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Default is false. When true, inline images are also listed as attachments in the response"""

    include: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Accepts \"users\". Use this parameter to list email CCs by side-loading users. Example: `?include=users`. **Note**: If the comment source is email, a deleted user will be represented as the CCd email address. If the comment source is anything else, a deleted user will be represented as the user name."""


class ListTicketCommentsResponseTypedDict(TypedDict):
    result: TicketCommentsResponseTypedDict


class ListTicketCommentsResponse(BaseModel):
    next: Callable[[], Optional[ListTicketCommentsResponse]]

    result: TicketCommentsResponse
