"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict
from zendesk.types import BaseModel
from zendesk.utils import FieldMetadata, QueryParamMetadata


class ListTicketFormsRequestTypedDict(TypedDict):
    active: NotRequired[bool]
    r"""true returns active ticket forms; false returns inactive ticket forms. If not present, returns both"""
    end_user_visible: NotRequired[bool]
    r"""true returns ticket forms where `end_user_visible`; false returns ticket forms that are not end-user visible. If not present, returns both"""
    fallback_to_default: NotRequired[bool]
    r"""true returns the default ticket form when the criteria defined by the parameters results in a set without active and end-user visible ticket forms"""
    associated_to_brand: NotRequired[bool]
    r"""true returns the ticket forms of the brand specified by the url's subdomain"""


class ListTicketFormsRequest(BaseModel):
    active: Annotated[
        Optional[bool],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""true returns active ticket forms; false returns inactive ticket forms. If not present, returns both"""

    end_user_visible: Annotated[
        Optional[bool],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""true returns ticket forms where `end_user_visible`; false returns ticket forms that are not end-user visible. If not present, returns both"""

    fallback_to_default: Annotated[
        Optional[bool],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""true returns the default ticket form when the criteria defined by the parameters results in a set without active and end-user visible ticket forms"""

    associated_to_brand: Annotated[
        Optional[bool],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""true returns the ticket forms of the brand specified by the url's subdomain"""
