"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from datetime import datetime
from enum import Enum
import pydantic
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict
from zendesk.types import BaseModel
from zendesk.utils import FieldMetadata, PathParamMetadata, QueryParamMetadata


class ListWebhookInvocationsFilterStatus(str, Enum):
    r"""Filters invocations by invocation status"""

    UNKNOWN = "unknown"
    ACCEPTED = "accepted"
    SUCCESS = "success"
    FAILED = "failed"
    TIMEOUT = "timeout"
    CIRCUIT_BROKEN = "circuit broken"
    THROTTLED = "throttled"
    CLIENT_ERROR = "client error"
    SERVER_ERROR = "server error"


class ListWebhookInvocationsSort(str, Enum):
    r"""Defines a invocation attribute to sort invocations"""

    LATEST_COMPLETED_AT = "latest_completed_at"
    MINUS_LATEST_COMPLETED_AT = "-latest_completed_at"


class ListWebhookInvocationsRequestTypedDict(TypedDict):
    webhook_id: str
    r"""Webhook id"""
    filter_from_ts: NotRequired[datetime]
    r"""Filters invocations by from timestamp. Use ISO 8601 UTC format"""
    filter_status: NotRequired[ListWebhookInvocationsFilterStatus]
    r"""Filters invocations by invocation status"""
    filter_to_ts: NotRequired[datetime]
    r"""Filters invocations by timestamp. Use ISO 8601 UTC format"""
    page_after: NotRequired[str]
    r"""Includes the next page of invocations with defined size"""
    page_before: NotRequired[str]
    r"""Includes the previous page of invocations with defined size"""
    page_size: NotRequired[str]
    r"""Defines a specific number of invocations per page"""
    sort: NotRequired[ListWebhookInvocationsSort]
    r"""Defines a invocation attribute to sort invocations"""


class ListWebhookInvocationsRequest(BaseModel):
    webhook_id: Annotated[
        str, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))
    ]
    r"""Webhook id"""

    filter_from_ts: Annotated[
        Optional[datetime],
        pydantic.Field(alias="filter[from_ts]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Filters invocations by from timestamp. Use ISO 8601 UTC format"""

    filter_status: Annotated[
        Optional[ListWebhookInvocationsFilterStatus],
        pydantic.Field(alias="filter[status]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Filters invocations by invocation status"""

    filter_to_ts: Annotated[
        Optional[datetime],
        pydantic.Field(alias="filter[to_ts]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Filters invocations by timestamp. Use ISO 8601 UTC format"""

    page_after: Annotated[
        Optional[str],
        pydantic.Field(alias="page[after]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Includes the next page of invocations with defined size"""

    page_before: Annotated[
        Optional[str],
        pydantic.Field(alias="page[before]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Includes the previous page of invocations with defined size"""

    page_size: Annotated[
        Optional[str],
        pydantic.Field(alias="page[size]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Defines a specific number of invocations per page"""

    sort: Annotated[
        Optional[ListWebhookInvocationsSort],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Defines a invocation attribute to sort invocations"""
