"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from enum import Enum
import pydantic
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict
from zendesk.types import BaseModel
from zendesk.utils import FieldMetadata, QueryParamMetadata


class ListWebhooksFilterStatus(str, Enum):
    r"""Filters the webhooks by webhook status"""

    ACTIVE = "active"
    INACTIVE = "inactive"


class ListWebhooksSort(str, Enum):
    r"""Defines the sorting criteria. Only supports name and status"""

    NAME = "name"
    STATUS = "status"


class ListWebhooksRequestTypedDict(TypedDict):
    filter_name_contains: NotRequired[str]
    r"""Filters the webhooks by a string in the name"""
    filter_status: NotRequired[ListWebhooksFilterStatus]
    r"""Filters the webhooks by webhook status"""
    page_after: NotRequired[str]
    r"""Includes the next page of results with defined size"""
    page_before: NotRequired[str]
    r"""Includes the previous page of results with defined size"""
    page_size: NotRequired[str]
    r"""Defines a specified number of results per page"""
    sort: NotRequired[ListWebhooksSort]
    r"""Defines the sorting criteria. Only supports name and status"""


class ListWebhooksRequest(BaseModel):
    filter_name_contains: Annotated[
        Optional[str],
        pydantic.Field(alias="filter[name_contains]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Filters the webhooks by a string in the name"""

    filter_status: Annotated[
        Optional[ListWebhooksFilterStatus],
        pydantic.Field(alias="filter[status]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Filters the webhooks by webhook status"""

    page_after: Annotated[
        Optional[str],
        pydantic.Field(alias="page[after]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Includes the next page of results with defined size"""

    page_before: Annotated[
        Optional[str],
        pydantic.Field(alias="page[before]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Includes the previous page of results with defined size"""

    page_size: Annotated[
        Optional[str],
        pydantic.Field(alias="page[size]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Defines a specified number of results per page"""

    sort: Annotated[
        Optional[ListWebhooksSort],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Defines the sorting criteria. Only supports name and status"""
