"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from datetime import datetime
import pydantic
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict
from zendesk.types import BaseModel


class OAuthClientObjectTypedDict(TypedDict):
    identifier: str
    r"""The unique identifier for this client"""
    name: str
    r"""The name of this client"""
    user_id: int
    r"""The id of the admin who created the client"""
    company: NotRequired[str]
    r"""The company name displayed when users are asked to grant access to your application."""
    created_at: NotRequired[datetime]
    r"""The time the client was created"""
    description: NotRequired[str]
    r"""A short description of your client that is displayed to users when they are considering approving access to your application"""
    global_: NotRequired[bool]
    r"""Whether this client is globally accessible. See [Set up a global OAuth client](/documentation/apps/publish-your-app-or-theme/global_oauth_intro/)"""
    id: NotRequired[int]
    r"""Automatically assigned upon creation"""
    kind: NotRequired[str]
    r"""Either \"public\" or \"confidential\". Specifies whether the OAuth client operates in a public environment where credentials cannot be securely stored, or on secure servers that can safely store credentials. See [Client types](/documentation/ticketing/working-with-oauth/oauth-pkce/#client-types)"""
    logo_url: NotRequired[str]
    r"""The API logo url of this record"""
    redirect_uri: NotRequired[List[str]]
    r"""An array of the valid redirect URIs for this client"""
    secret: NotRequired[str]
    r"""The client secret. Generated automatically on creation and returned in full only at that time"""
    updated_at: NotRequired[datetime]
    r"""The time of the last update of the client"""
    url: NotRequired[str]
    r"""The API url of this record"""


class OAuthClientObject(BaseModel):
    identifier: str
    r"""The unique identifier for this client"""

    name: str
    r"""The name of this client"""

    user_id: int
    r"""The id of the admin who created the client"""

    company: Optional[str] = None
    r"""The company name displayed when users are asked to grant access to your application."""

    created_at: Optional[datetime] = None
    r"""The time the client was created"""

    description: Optional[str] = None
    r"""A short description of your client that is displayed to users when they are considering approving access to your application"""

    global_: Annotated[Optional[bool], pydantic.Field(alias="global")] = None
    r"""Whether this client is globally accessible. See [Set up a global OAuth client](/documentation/apps/publish-your-app-or-theme/global_oauth_intro/)"""

    id: Optional[int] = None
    r"""Automatically assigned upon creation"""

    kind: Optional[str] = None
    r"""Either \"public\" or \"confidential\". Specifies whether the OAuth client operates in a public environment where credentials cannot be securely stored, or on secure servers that can safely store credentials. See [Client types](/documentation/ticketing/working-with-oauth/oauth-pkce/#client-types)"""

    logo_url: Optional[str] = None
    r"""The API logo url of this record"""

    redirect_uri: Optional[List[str]] = None
    r"""An array of the valid redirect URIs for this client"""

    secret: Optional[str] = None
    r"""The client secret. Generated automatically on creation and returned in full only at that time"""

    updated_at: Optional[datetime] = None
    r"""The time of the last update of the client"""

    url: Optional[str] = None
    r"""The API url of this record"""
