"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from datetime import datetime
from typing import List, Optional
from typing_extensions import NotRequired, TypedDict
from zendesk.types import BaseModel


class OauthTokenObjectTypedDict(TypedDict):
    client_id: NotRequired[int]
    r"""The id of the client this token belongs to"""
    created_at: NotRequired[datetime]
    r"""The time the token was created"""
    expires_at: NotRequired[datetime]
    r"""The time the token will expire"""
    id: NotRequired[int]
    r"""Automatically assigned upon creation"""
    refresh_token: NotRequired[str]
    r"""The refresh token, if generated"""
    refresh_token_expires_at: NotRequired[datetime]
    r"""The time the refresh token will expire"""
    scopes: NotRequired[List[str]]
    r"""An array of the valid scopes for this token. See [Scopes](#scopes) below"""
    token: NotRequired[str]
    r"""The access token"""
    url: NotRequired[str]
    r"""The API url of this record"""
    used_at: NotRequired[datetime]
    r"""The latest time this token was used for authentication"""
    user_id: NotRequired[int]
    r"""The id of the user this token authenticates as"""


class OauthTokenObject(BaseModel):
    client_id: Optional[int] = None
    r"""The id of the client this token belongs to"""

    created_at: Optional[datetime] = None
    r"""The time the token was created"""

    expires_at: Optional[datetime] = None
    r"""The time the token will expire"""

    id: Optional[int] = None
    r"""Automatically assigned upon creation"""

    refresh_token: Optional[str] = None
    r"""The refresh token, if generated"""

    refresh_token_expires_at: Optional[datetime] = None
    r"""The time the refresh token will expire"""

    scopes: Optional[List[str]] = None
    r"""An array of the valid scopes for this token. See [Scopes](#scopes) below"""

    token: Optional[str] = None
    r"""The access token"""

    url: Optional[str] = None
    r"""The API url of this record"""

    used_at: Optional[datetime] = None
    r"""The latest time this token was used for authentication"""

    user_id: Optional[int] = None
    r"""The id of the user this token authenticates as"""
