"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .organizationsubscriptionobject import (
    OrganizationSubscriptionObject,
    OrganizationSubscriptionObjectTypedDict,
)
from pydantic import model_serializer
from typing import List, Optional
from typing_extensions import NotRequired, TypedDict
from zendesk.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL


class OrganizationSubscriptionsResponseTypedDict(TypedDict):
    count: NotRequired[int]
    r"""the total record count"""
    next_page: NotRequired[Nullable[str]]
    r"""the URL of the next page"""
    previous_page: NotRequired[Nullable[str]]
    r"""the URL of the previous page"""
    organization_subscriptions: NotRequired[
        List[OrganizationSubscriptionObjectTypedDict]
    ]
    r"""An array of organization subscriptions"""


class OrganizationSubscriptionsResponse(BaseModel):
    count: Optional[int] = None
    r"""the total record count"""

    next_page: OptionalNullable[str] = UNSET
    r"""the URL of the next page"""

    previous_page: OptionalNullable[str] = UNSET
    r"""the URL of the previous page"""

    organization_subscriptions: Optional[List[OrganizationSubscriptionObject]] = None
    r"""An array of organization subscriptions"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "count",
            "next_page",
            "previous_page",
            "organization_subscriptions",
        ]
        nullable_fields = ["next_page", "previous_page"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
