"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .ticketauditviaobject import TicketAuditViaObject, TicketAuditViaObjectTypedDict
from datetime import datetime
from typing import List, Optional
from typing_extensions import NotRequired, TypedDict
from zendesk.types import BaseModel


class RequestObjectCustomFieldTypedDict(TypedDict):
    id: NotRequired[int]
    value: NotRequired[str]


class RequestObjectCustomField(BaseModel):
    id: Optional[int] = None

    value: Optional[str] = None


class RequestObjectTypedDict(TypedDict):
    subject: str
    r"""The value of the subject field for this request if the subject field is visible to end users; a truncated version of the description otherwise"""
    assignee_id: NotRequired[int]
    r"""The id of the assignee if the field is visible to end users"""
    can_be_solved_by_me: NotRequired[bool]
    r"""If true, an end user can mark the request as solved. See [Update Request](/api-reference/ticketing/tickets/ticket-requests/#update-request)"""
    collaborator_ids: NotRequired[List[int]]
    r"""The ids of users currently CC'ed on the ticket"""
    created_at: NotRequired[datetime]
    r"""When this record was created"""
    custom_fields: NotRequired[List[RequestObjectCustomFieldTypedDict]]
    r"""Custom fields for the request. See [Setting custom field values](/api-reference/ticketing/tickets/tickets/#setting-custom-field-values) in the Tickets doc"""
    custom_status_id: NotRequired[int]
    r"""The custom ticket status id of the ticket"""
    description: NotRequired[str]
    r"""Read-only first comment on the request. When [creating a request](#create-request), use `comment` to set the description"""
    due_at: NotRequired[datetime]
    r"""When the task is due (only applies if the request is of type \"task\")"""
    email_cc_ids: NotRequired[List[int]]
    r"""The ids of users who are currently email CCs on the ticket. See [CCs and followers resources](https://support.zendesk.com/hc/en-us/articles/360020585233) in the Support Help Center"""
    followup_source_id: NotRequired[int]
    r"""The id of the original ticket if this request is a follow-up ticket. See [Create Request](#create-request)"""
    group_id: NotRequired[int]
    r"""The id of the assigned group if the field is visible to end users"""
    id: NotRequired[int]
    r"""Automatically assigned when creating requests"""
    is_public: NotRequired[bool]
    r"""Is true if any comments are public, false otherwise"""
    organization_id: NotRequired[int]
    r"""The organization of the requester"""
    priority: NotRequired[str]
    r"""The priority of the request, \"low\", \"normal\", \"high\", \"urgent\" """
    recipient: NotRequired[str]
    r"""The original recipient e-mail address of the request"""
    requester_id: NotRequired[int]
    r"""The id of the requester"""
    solved: NotRequired[bool]
    r"""Whether or not request is solved (an end user can set this if \"can_be_solved_by_me\", above, is true for that user)"""
    status: NotRequired[str]
    r"""The state of the request, \"new\", \"open\", \"pending\", \"hold\", \"solved\", \"closed\" """
    ticket_form_id: NotRequired[int]
    r"""The numeric id of the ticket form associated with this request if the form is visible to end users - only applicable for enterprise accounts"""
    type: NotRequired[str]
    r"""The type of the request, \"question\", \"incident\", \"problem\", \"task\" """
    updated_at: NotRequired[datetime]
    r"""When this record last got updated"""
    url: NotRequired[str]
    r"""The API url of this request"""
    via: NotRequired[TicketAuditViaObjectTypedDict]
    r"""Describes how the object was created. See the [Via object reference](/documentation/ticketing/reference-guides/via-object-reference)"""


class RequestObject(BaseModel):
    subject: str
    r"""The value of the subject field for this request if the subject field is visible to end users; a truncated version of the description otherwise"""

    assignee_id: Optional[int] = None
    r"""The id of the assignee if the field is visible to end users"""

    can_be_solved_by_me: Optional[bool] = None
    r"""If true, an end user can mark the request as solved. See [Update Request](/api-reference/ticketing/tickets/ticket-requests/#update-request)"""

    collaborator_ids: Optional[List[int]] = None
    r"""The ids of users currently CC'ed on the ticket"""

    created_at: Optional[datetime] = None
    r"""When this record was created"""

    custom_fields: Optional[List[RequestObjectCustomField]] = None
    r"""Custom fields for the request. See [Setting custom field values](/api-reference/ticketing/tickets/tickets/#setting-custom-field-values) in the Tickets doc"""

    custom_status_id: Optional[int] = None
    r"""The custom ticket status id of the ticket"""

    description: Optional[str] = None
    r"""Read-only first comment on the request. When [creating a request](#create-request), use `comment` to set the description"""

    due_at: Optional[datetime] = None
    r"""When the task is due (only applies if the request is of type \"task\")"""

    email_cc_ids: Optional[List[int]] = None
    r"""The ids of users who are currently email CCs on the ticket. See [CCs and followers resources](https://support.zendesk.com/hc/en-us/articles/360020585233) in the Support Help Center"""

    followup_source_id: Optional[int] = None
    r"""The id of the original ticket if this request is a follow-up ticket. See [Create Request](#create-request)"""

    group_id: Optional[int] = None
    r"""The id of the assigned group if the field is visible to end users"""

    id: Optional[int] = None
    r"""Automatically assigned when creating requests"""

    is_public: Optional[bool] = None
    r"""Is true if any comments are public, false otherwise"""

    organization_id: Optional[int] = None
    r"""The organization of the requester"""

    priority: Optional[str] = None
    r"""The priority of the request, \"low\", \"normal\", \"high\", \"urgent\" """

    recipient: Optional[str] = None
    r"""The original recipient e-mail address of the request"""

    requester_id: Optional[int] = None
    r"""The id of the requester"""

    solved: Optional[bool] = None
    r"""Whether or not request is solved (an end user can set this if \"can_be_solved_by_me\", above, is true for that user)"""

    status: Optional[str] = None
    r"""The state of the request, \"new\", \"open\", \"pending\", \"hold\", \"solved\", \"closed\" """

    ticket_form_id: Optional[int] = None
    r"""The numeric id of the ticket form associated with this request if the form is visible to end users - only applicable for enterprise accounts"""

    type: Optional[str] = None
    r"""The type of the request, \"question\", \"incident\", \"problem\", \"task\" """

    updated_at: Optional[datetime] = None
    r"""When this record last got updated"""

    url: Optional[str] = None
    r"""The API url of this request"""

    via: Optional[TicketAuditViaObject] = None
    r"""Describes how the object was created. See the [Via object reference](/documentation/ticketing/reference-guides/via-object-reference)"""
