"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict
from zendesk.types import BaseModel
from zendesk.utils import FieldMetadata, QueryParamMetadata


class SearchAutomationsRequestTypedDict(TypedDict):
    query: str
    r"""Query string used to find all automations with matching title"""
    active: NotRequired[bool]
    r"""Filter by active automations if true or inactive automations if false"""
    sort_by: NotRequired[str]
    r"""Possible values are \"alphabetical\", \"created_at\", \"updated_at\", and \"position\". If unspecified, the automations are sorted by relevance"""
    sort_order: NotRequired[str]
    r"""One of \"asc\" or \"desc\". Defaults to \"asc\" for alphabetical and position sort, \"desc\" for all others"""
    include: NotRequired[str]
    r"""A sideload to include in the response. See [Sideloads](#sideloads-2)"""


class SearchAutomationsRequest(BaseModel):
    query: Annotated[
        str, FieldMetadata(query=QueryParamMetadata(style="form", explode=True))
    ]
    r"""Query string used to find all automations with matching title"""

    active: Annotated[
        Optional[bool],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Filter by active automations if true or inactive automations if false"""

    sort_by: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Possible values are \"alphabetical\", \"created_at\", \"updated_at\", and \"position\". If unspecified, the automations are sorted by relevance"""

    sort_order: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""One of \"asc\" or \"desc\". Defaults to \"asc\" for alphabetical and position sort, \"desc\" for all others"""

    include: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""A sideload to include in the response. See [Sideloads](#sideloads-2)"""
